/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.vertx.common;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AbstractEventLoopGroup;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.kqueue.KQueueChannelOption;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.SucceededFuture;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.transport.Transport;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.netty.common.NettyChannelFactory;

public class VertxEventLoopGroupTransport
extends Transport {
    private final TransportType type;
    private final EventLoopGroup eventLoopGroup;
    private final NettyChannelFactory nettyChannelFactory;

    public VertxEventLoopGroupTransport(EventLoopGroup eventLoopGroup, NettyChannelFactory nettyChannelFactory) {
        this.eventLoopGroup = eventLoopGroup;
        this.nettyChannelFactory = nettyChannelFactory;
        this.type = this.eventLoopGroup.getClass().getName().contains("Epoll") ? TransportType.EPOLL : (this.eventLoopGroup.getClass().getName().contains("KQueue") ? TransportType.KQUEUE : TransportType.NIO);
    }

    public boolean isAvailable() {
        return true;
    }

    public Throwable unavailabilityCause() {
        return null;
    }

    public java.net.SocketAddress convert(SocketAddress address) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case TransportType.NIO -> super.convert(address);
            case TransportType.EPOLL, TransportType.KQUEUE -> address.isDomainSocket() ? new DomainSocketAddress(address.path()) : super.convert(address);
        };
    }

    public SocketAddress convert(java.net.SocketAddress address) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case TransportType.NIO -> super.convert(address);
            case TransportType.EPOLL, TransportType.KQUEUE -> address instanceof DomainSocketAddress ? new SocketAddressImpl(((DomainSocketAddress)address).path()) : super.convert(address);
        };
    }

    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        return new AbstractEventLoopGroup(){
            private final EventLoopGroup eventLoopGroup;
            {
                this.eventLoopGroup = VertxEventLoopGroupTransport.this.eventLoopGroup;
            }

            public EventLoop next() {
                return this.eventLoopGroup.next();
            }

            public ChannelFuture register(Channel channel) {
                return this.eventLoopGroup.register(channel);
            }

            @Deprecated
            public ChannelFuture register(ChannelPromise promise) {
                return this.eventLoopGroup.register(promise);
            }

            @Deprecated
            public ChannelFuture register(Channel channel, ChannelPromise promise) {
                return this.eventLoopGroup.register(channel, promise);
            }

            @Deprecated
            public void shutdown() {
            }

            public boolean isShuttingDown() {
                return false;
            }

            public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
                return new SucceededFuture((EventExecutor)this.eventLoopGroup.next(), null);
            }

            public Future<?> terminationFuture() {
                return null;
            }

            public Iterator<EventExecutor> iterator() {
                return this.eventLoopGroup.iterator();
            }

            public boolean isShutdown() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
                return false;
            }
        };
    }

    public DatagramChannel datagramChannel() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case TransportType.NIO -> new NioDatagramChannel();
            case TransportType.EPOLL -> new EpollDatagramChannel();
            case TransportType.KQUEUE -> new KQueueDatagramChannel();
        };
    }

    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case TransportType.NIO -> super.datagramChannel(family);
            case TransportType.EPOLL -> new EpollDatagramChannel();
            case TransportType.KQUEUE -> new KQueueDatagramChannel();
        };
    }

    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (this.type == TransportType.NIO && domainSocket) {
            throw new IllegalArgumentException("The Vertx instance must be created with the preferNativeTransport option set to true to create domain sockets");
        }
        return this.nettyChannelFactory.getClientFactory(domainSocket);
    }

    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (this.type == TransportType.NIO && domainSocket) {
            throw new IllegalArgumentException("The Vertx instance must be created with the preferNativeTransport option set to true to create domain sockets");
        }
        return this.nettyChannelFactory.getServerFactory(domainSocket);
    }

    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        switch (this.type) {
            case EPOLL: 
            case KQUEUE: {
                channel.config().setOption(EpollChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
                break;
            }
        }
        super.configure(channel, options);
    }

    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (this.type == TransportType.EPOLL && !domainSocket) {
            if (options.isTcpFastOpen()) {
                bootstrap.option(ChannelOption.TCP_FASTOPEN_CONNECT, (Object)options.isTcpFastOpen());
            }
            bootstrap.option(EpollChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
            bootstrap.option(EpollChannelOption.TCP_CORK, (Object)options.isTcpCork());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (this.type == TransportType.EPOLL && !domainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
            if (options.isTcpFastOpen()) {
                bootstrap.option(ChannelOption.TCP_FASTOPEN, (Object)(options.isTcpFastOpen() ? 256 : 0));
            }
            bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
            bootstrap.childOption(EpollChannelOption.TCP_CORK, (Object)options.isTcpCork());
        }
        if (this.type == TransportType.KQUEUE && !domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    public static enum TransportType {
        NIO,
        EPOLL,
        KQUEUE;

    }
}

