package ru.tinkoff.kotea.android.internal.get_store

import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.ViewModelStoreOwner
import ru.tinkoff.kotea.android.internal.StoreViewModel
import ru.tinkoff.kotea.android.internal.utils.generateViewModelKey
import ru.tinkoff.kotea.core.Store
import kotlin.reflect.KProperty

internal class GetStoreViewModelDelegate<T : Store<*, *, *>>(
    private val sharedViewModelKey: String? = null,
    private val viewModelStoreOwnerProvider: (() -> ViewModelStoreOwner),
) {

    operator fun invoke(property: KProperty<*>): T {
        val viewModelStoreOwner = viewModelStoreOwnerProvider()
        val key = sharedViewModelKey ?: generateViewModelKey(viewModelStoreOwner, property)
        val viewModelProvider = ViewModelProvider(viewModelStoreOwner)
        val viewModel = viewModelProvider.get(key, StoreViewModel::class.java) as StoreViewModel<T>
        return viewModel.store
    }
}
