package ru.tinkoff.kotea.android.internal.get_store

import androidx.lifecycle.ViewModelStoreOwner
import ru.tinkoff.kotea.core.Store
import kotlin.properties.ReadOnlyProperty
import kotlin.reflect.KProperty

internal class SafetyGetStoreFromViewModel<T : Store<*, *, *>>(
    sharedViewModelKey: String? = null,
    viewModelStoreOwnerProvider: (() -> ViewModelStoreOwner),
) : ReadOnlyProperty<ViewModelStoreOwner, T?> {

    private val getStoreDelegate: GetStoreViewModelDelegate<T> = GetStoreViewModelDelegate(
        sharedViewModelKey,
        viewModelStoreOwnerProvider
    )

    override fun getValue(thisRef: ViewModelStoreOwner, property: KProperty<*>): T? {
        return try {
            getStoreDelegate(property)
        } catch (exception: RuntimeException) {
            null
        }
    }
}
