/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kotea.logging;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kotea.core.Next;
import ru.tinkoff.kotea.core.Update;
import ru.tinkoff.kotea.logging.KoteaLogger;
import ru.tinkoff.kotea.logging.LoggingExtKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u0002*\b\b\u0003\u0010\u0005*\u00020\u00022\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00050\u0006B5\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ/\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/tinkoff/kotea/logging/LoggingUpdate;", "State", "", "Event", "Command", "News", "Lru/tinkoff/kotea/core/Update;", "delegate", "tag", "", "logger", "Lru/tinkoff/kotea/logging/KoteaLogger;", "(Lru/tinkoff/kotea/core/Update;Ljava/lang/String;Lru/tinkoff/kotea/logging/KoteaLogger;)V", "update", "Lru/tinkoff/kotea/core/Next;", "state", "event", "(Ljava/lang/Object;Ljava/lang/Object;)Lru/tinkoff/kotea/core/Next;", "logging"})
public final class LoggingUpdate<State, Event, Command, News>
implements Update<State, Event, Command, News> {
    @NotNull
    private final Update<State, Event, Command, News> delegate;
    @NotNull
    private final String tag;
    @NotNull
    private final KoteaLogger logger;

    public LoggingUpdate(@NotNull Update<State, ? super Event, ? extends Command, ? extends News> delegate, @NotNull String tag, @NotNull KoteaLogger logger) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.delegate = delegate;
        this.tag = tag;
        this.logger = logger;
    }

    @NotNull
    public Next<State, Command, News> update(@NotNull State state, @NotNull Event event) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Next next = this.delegate.update(state, event);
        this.logger.debug(this.tag, "Event: " + LoggingExtKt.removePackage(event.toString(), this.delegate.getClass()));
        if (next.getState() != null) {
            this.logger.debug(this.tag, "State: " + LoggingExtKt.removePackage(String.valueOf(next.getState()), this.delegate.getClass()));
        }
        if (!((Collection)next.getCommands()).isEmpty()) {
            for (Object command : next.getCommands()) {
                this.logger.debug(this.tag, "Command: " + LoggingExtKt.removePackage(command.toString(), this.delegate.getClass()));
            }
        }
        if (!((Collection)next.getNews()).isEmpty()) {
            for (Object news : next.getNews()) {
                this.logger.debug(this.tag, "News: " + LoggingExtKt.removePackage(news.toString(), this.delegate.getClass()));
            }
        }
        return next;
    }
}

