/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.InsuranceData;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.SimpleData;
import ru.tinkoff.tisdk.casco.CascoData;
import ru.tinkoff.tisdk.scan.Scan;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public interface BuyingProcess {
    public void setPrePricingListener(@Nullable PricingListener var1);

    public void setPricingListener(@Nullable PricingListener var1);

    public void setNeedDiagnosticCardListener(@Nullable NeedDiagnosticCardListener var1);

    public void setUpdateDealListener(@Nullable UpdateDealListener var1);

    public void setUploadPhotosDocumentsListener(@Nullable UploadPhotosDocumentsListener var1);

    public void setSendSMSCodeListener(@Nullable SMSCodeListener var1);

    public void setSettingSMSCodeListener(@Nullable SMSCodeListener var1);

    public void calculatePrePrice(@NotNull SimpleData var1);

    public void calculatePrice(@NotNull InsuranceData var1);

    public void checkNeedDiagnosticCard(@NotNull VehicleDocument var1, @NotNull Date var2);

    public void updateDeal();

    public void uploadPhotosDocuments(@NotNull Map<Scan, List<File>> var1);

    public void sendCode();

    public void setCode(@NotNull String var1);

    public void updateSimpleData(@Nullable SimpleData var1);

    @NotNull
    public SimpleData getPreData();

    @NotNull
    public Deal getDealData();

    @NotNull
    public InsuranceData getInsuranceData();

    @Nullable
    public CascoData getCascoData();

    @NotNull
    public State getState();

    @NotNull
    public String getFioPassport(int var1, boolean var2);

    @NotNull
    public String getFioDriverLicense(int var1, boolean var2);

    @NotNull
    public String getVehicleName();

    @NotNull
    public VehicleDocument.TypeDocument getVehicleDocumentType();

    @NotNull
    public List<Scan> getNeedPhotosDocuments();

    @NotNull
    public InsuranceRate getSimpleRate();

    @Nullable
    public Boolean isCorrectUserType();

    public void updateInsuranceData(@Nullable InsuranceData var1);

    public boolean isNeedPreDiagnosticCard();

    public boolean isNeedDiagnosticCard();

    public boolean isDealCompleted();

    public void createCascoRequest(@NotNull CascoData var1) throws Exception;

    public void resetOsago() throws Exception;

    public void resetCasco() throws Exception;

    public void restore() throws Exception;

    public void restore(@NotNull State var1);

    public static interface SMSCodeListener {
        public void onStart();

        public void onSuccess();

        public void onError(@NotNull Throwable var1);
    }

    public static interface UploadPhotosDocumentsListener {
        public void onStart();

        public void onSuccess();

        public void onError(@NotNull Throwable var1);
    }

    public static interface UpdateDealListener {
        public void onPaymentOrderCompleted();

        public void onStart();

        public void onSuccess(@NotNull Deal var1);

        public void onError(@NotNull Throwable var1);
    }

    public static interface NeedDiagnosticCardListener {
        public void onStart();

        public void onSuccess(boolean var1);

        public void onError(@NotNull Throwable var1);
    }

    public static interface PricingListener {
        public void onDealCompleted();

        public void onStart();

        public void onSuccess(@NotNull InsuranceRate var1);

        public void onError(@NotNull Throwable var1);
    }

    public static interface State<T extends BuyingProcess>
    extends Serializable {
        public void restore(@NotNull T var1);
    }
}

