/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.BuyingProcess;
import ru.tinkoff.tisdk.ConnectivityChecker;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.InsuranceConditions;
import ru.tinkoff.tisdk.InsuranceData;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.NeedDiagnosticCardException;
import ru.tinkoff.tisdk.NotConnectedException;
import ru.tinkoff.tisdk.RestorationManager;
import ru.tinkoff.tisdk.SimpleData;
import ru.tinkoff.tisdk.SravniRuCalcInfo;
import ru.tinkoff.tisdk.address.City;
import ru.tinkoff.tisdk.auth.AuthService;
import ru.tinkoff.tisdk.auth.IncorrectUserTypeException;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.casco.CascoData;
import ru.tinkoff.tisdk.gateway.exception.CompleteException;
import ru.tinkoff.tisdk.scan.FileInfo;
import ru.tinkoff.tisdk.scan.NeedScansException;
import ru.tinkoff.tisdk.scan.QuoteSet;
import ru.tinkoff.tisdk.scan.Scan;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.subject.Drivers;
import ru.tinkoff.tisdk.subject.Insurer;
import ru.tinkoff.tisdk.utils.CommonUtils;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;
import ru.tinkoff.tisdk.vehicle.Vehicle;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class BuyingProcessImpl
implements BuyingProcess {
    private static final String CLIENT_TYPE_DEFAULT = "jfk1lah11ng4";
    private static final int MAX_COUNT_SCAN_FOR_DOCUMENT = 2;
    private static final int COUNT_YEAR_FOR_DIAGNOSTIC_CARD = 3;
    private final AuthService authService;
    private final ApiGateway apiGateway;
    private final ConnectivityChecker connectivityChecker;
    private final RestorationManager restorationManager;
    private final Scheduler workerScheduler;
    private final Scheduler outputScheduler;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private volatile StateImpl state = new StateImpl();
    private BuyingProcess.PricingListener prePricingListener;
    private BuyingProcess.PricingListener pricingListener;
    private BuyingProcess.NeedDiagnosticCardListener needDiagnosticCardListener;
    private BuyingProcess.UpdateDealListener updateDealListener;
    private BuyingProcess.UploadPhotosDocumentsListener uploadPhotosDocumentsListener;
    private BuyingProcess.SMSCodeListener sendSmsCodeListener;
    private BuyingProcess.SMSCodeListener settingSmsCodeListener;

    public BuyingProcessImpl(@NotNull ApiGateway apiGateway, @NotNull AuthService authService, @NotNull ConnectivityChecker connectivityChecker, @NotNull RestorationManager restorationManager, @NotNull Scheduler workerScheduler, @NotNull Scheduler outputScheduler) {
        Preconditions.checkNotNull(authService);
        Preconditions.checkNotNull(apiGateway);
        Preconditions.checkNotNull(connectivityChecker);
        Preconditions.checkNotNull(restorationManager);
        this.authService = authService;
        this.apiGateway = apiGateway;
        this.connectivityChecker = connectivityChecker;
        this.restorationManager = restorationManager;
        this.workerScheduler = workerScheduler;
        this.outputScheduler = outputScheduler;
    }

    @Override
    public void setPrePricingListener(@Nullable BuyingProcess.PricingListener listener) {
        this.prePricingListener = listener;
    }

    @Override
    public void setPricingListener(@Nullable BuyingProcess.PricingListener listener) {
        this.pricingListener = listener;
    }

    @Override
    public void setNeedDiagnosticCardListener(@Nullable BuyingProcess.NeedDiagnosticCardListener listener) {
        this.needDiagnosticCardListener = listener;
    }

    @Override
    public void setUpdateDealListener(@Nullable BuyingProcess.UpdateDealListener listener) {
        this.updateDealListener = listener;
    }

    @Override
    public void setUploadPhotosDocumentsListener(@Nullable BuyingProcess.UploadPhotosDocumentsListener listener) {
        this.uploadPhotosDocumentsListener = listener;
    }

    @Override
    public void setSendSMSCodeListener(@Nullable BuyingProcess.SMSCodeListener listener) {
        this.sendSmsCodeListener = listener;
    }

    @Override
    public void setSettingSMSCodeListener(@Nullable BuyingProcess.SMSCodeListener listener) {
        this.settingSmsCodeListener = listener;
    }

    @Override
    public void calculatePrePrice(@NotNull SimpleData data) {
        Preconditions.checkNotNull(data);
        if (this.isDealCompleted()) {
            if (this.prePricingListener != null) {
                this.prePricingListener.onDealCompleted();
            }
        } else {
            this.disposables.add(Single.fromCallable(() -> this._prePricing(data)).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
                if (this.prePricingListener != null) {
                    this.prePricingListener.onStart();
                }
            }).subscribe(rate -> {
                if (this.prePricingListener != null) {
                    this.prePricingListener.onSuccess((InsuranceRate)rate);
                }
            }, e -> {
                if (this.prePricingListener != null) {
                    this.prePricingListener.onError((Throwable)e);
                }
            }));
        }
    }

    @Override
    public void calculatePrice(@NotNull InsuranceData newInsuranceData) {
        Preconditions.checkNotNull(newInsuranceData);
        this.checkSimpleData();
        if (this.isDealCompleted()) {
            if (this.pricingListener != null) {
                this.pricingListener.onDealCompleted();
            }
        } else {
            this.disposables.add(Single.fromCallable(() -> this._pricing(newInsuranceData)).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
                if (this.pricingListener != null) {
                    this.pricingListener.onStart();
                }
            }).subscribe(rate -> {
                if (this.pricingListener != null) {
                    this.pricingListener.onSuccess((InsuranceRate)rate);
                }
            }, e -> {
                if (this.pricingListener != null) {
                    this.pricingListener.onError((Throwable)e);
                }
            }));
        }
    }

    @Override
    public void checkNeedDiagnosticCard(@NotNull VehicleDocument vehicleDocument, @NotNull Date effective) {
        this.checkSimpleData();
        this.disposables.add(Single.fromCallable(() -> this._checkNeedDiagnosticCard(vehicleDocument, effective)).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
            if (this.needDiagnosticCardListener != null) {
                this.needDiagnosticCardListener.onStart();
            }
        }).subscribe(need -> {
            if (this.needDiagnosticCardListener != null) {
                this.needDiagnosticCardListener.onSuccess((boolean)need);
            }
        }, e -> {
            if (this.needDiagnosticCardListener != null) {
                this.needDiagnosticCardListener.onError((Throwable)e);
            }
        }));
    }

    @Override
    public void updateDeal() {
        this.checkInsuranceData();
        this.checkRate();
        if (this.isDealCompleted() && this.state.deal.isPaymentOrderCompleted()) {
            if (this.updateDealListener != null) {
                this.updateDealListener.onPaymentOrderCompleted();
            }
        } else {
            this.disposables.add(Single.fromCallable(() -> {
                if (!this.isDealCompleted()) {
                    this._updateDeal();
                }
                return this.buy();
            }).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
                if (this.updateDealListener != null) {
                    this.updateDealListener.onStart();
                }
            }).subscribe(deal -> {
                if (this.updateDealListener != null) {
                    this.updateDealListener.onSuccess((Deal)deal);
                }
            }, e -> {
                if (this.updateDealListener != null) {
                    this.updateDealListener.onError((Throwable)e);
                }
            }));
        }
    }

    @Override
    public void uploadPhotosDocuments(@NotNull Map<Scan, List<File>> photosDocuments) {
        this.checkInsuranceData();
        this.checkDealData();
        this.disposables.add(Completable.fromAction(() -> this._uploadScanDocuments(photosDocuments)).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
            if (this.uploadPhotosDocumentsListener != null) {
                this.uploadPhotosDocumentsListener.onStart();
            }
        }).subscribe(() -> {
            if (this.uploadPhotosDocumentsListener != null) {
                this.uploadPhotosDocumentsListener.onSuccess();
            }
        }, e -> {
            if (this.uploadPhotosDocumentsListener != null) {
                this.uploadPhotosDocumentsListener.onError((Throwable)e);
            }
        }));
    }

    @Override
    public void sendCode() {
        this.disposables.add(Completable.fromAction(this::_sendCode).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
            if (this.sendSmsCodeListener != null) {
                this.sendSmsCodeListener.onStart();
            }
        }).subscribe(() -> {
            if (this.sendSmsCodeListener != null) {
                this.sendSmsCodeListener.onSuccess();
            }
        }, e -> {
            if (this.sendSmsCodeListener != null) {
                this.sendSmsCodeListener.onError((Throwable)e);
            }
        }));
    }

    @Override
    public void setCode(@NotNull String code) {
        this.disposables.add(Completable.fromAction(() -> this._setCode(code)).subscribeOn(this.workerScheduler).observeOn(this.outputScheduler).doOnSubscribe(d -> {
            if (this.settingSmsCodeListener != null) {
                this.settingSmsCodeListener.onStart();
            }
        }).subscribe(() -> {
            if (this.settingSmsCodeListener != null) {
                this.settingSmsCodeListener.onSuccess();
            }
        }, e -> {
            if (this.settingSmsCodeListener != null) {
                this.settingSmsCodeListener.onError((Throwable)e);
            }
        }));
    }

    @Override
    public void createCascoRequest(@NotNull CascoData data) throws Exception {
        String id;
        this.checkConnection();
        if (this.state.cascoData != null && !StringUtilsKt.isEmpty(this.state.cascoData.getRequestId()) && this.state.cascoData.getContact().getPhone().equals(data.getContact().getPhone())) {
            id = this.state.cascoData.getRequestId();
        } else {
            this.state.cascoData = data;
            id = this.apiGateway.createCascoRequest(data);
        }
        if (StringUtilsKt.isEmpty(id)) {
            throw new IllegalStateException("Casco application id is invalid: " + this.state.cascoData.getRequestId());
        }
        this.state.cascoData.setRequestId(id);
        this.updateVehicleDetailsIfNeeded(this.state.cascoData.getVehicle(), this.state.cascoData.getCity());
        String newId = this.apiGateway.updateCascoRequest(this.state.cascoData);
        if (!id.equals(newId)) {
            throw new IllegalStateException("Casco application id is invalid: " + newId);
        }
        this.saveState();
    }

    @Override
    @NotNull
    public String getFioPassport(int subjectNumber, boolean full) {
        Contact subject;
        this.checkInsuranceData();
        if (2 == subjectNumber) {
            subject = this.state.insuranceData.getOwner();
        } else if (1 == subjectNumber) {
            subject = this.state.insuranceData.getInsurer();
        } else {
            throw new IllegalArgumentException();
        }
        if (full) {
            return CommonUtils.getFullFio(subject);
        }
        return CommonUtils.getShortFio(subject);
    }

    @Override
    @NotNull
    public String getFioDriverLicense(int subjectNumber, boolean full) {
        this.checkInsuranceData();
        Driver driver = this.state.insuranceData.getDrivers().getDriver(subjectNumber);
        if (driver != null) {
            if (full) {
                return CommonUtils.getFullFio(driver);
            }
            return CommonUtils.getShortFio(driver);
        }
        throw this.generateStateException();
    }

    @Override
    @NotNull
    public String getVehicleName() {
        this.checkSimpleData();
        Vehicle vehicle = this.state.simpleData.getVehicle();
        return String.format("%s %s", vehicle.getMakeName(), vehicle.getModelName());
    }

    @Override
    @NotNull
    public VehicleDocument.TypeDocument getVehicleDocumentType() {
        this.checkInsuranceData();
        return this.state.insuranceData.getVehicleDocument().getTypeDocument();
    }

    @Override
    public boolean isNeedPreDiagnosticCard() {
        this.checkSimpleData();
        int currentYear = DateUtils.getCalendar().get(1);
        return this.state.simpleData.getVehicle().getYear() <= currentYear - 3;
    }

    @Override
    public boolean isNeedDiagnosticCard() {
        return this.state.dcState == DiagnosticCardState.NEED;
    }

    @Override
    @NotNull
    public SimpleData getPreData() {
        this.checkSimpleData();
        return this.state.simpleData;
    }

    @Override
    @NotNull
    public InsuranceData getInsuranceData() {
        this.checkInsuranceData();
        return this.state.insuranceData;
    }

    @Override
    public boolean isDealCompleted() {
        return this.state.deal != null && this.state.deal.isCompleted();
    }

    @Override
    @NotNull
    public Deal getDealData() {
        this.checkDealData();
        return this.state.deal;
    }

    @Override
    @Nullable
    public CascoData getCascoData() {
        return this.state.cascoData;
    }

    @Override
    @NotNull
    public InsuranceRate getSimpleRate() {
        this.checkRate();
        return this.state.insuranceRate;
    }

    @Override
    @Nullable
    public Boolean isCorrectUserType() {
        return this.state.isCorrectUserType;
    }

    @Override
    public void updateSimpleData(@Nullable SimpleData newSimpleData) {
        this.disposables.add(Completable.fromAction(() -> this._updateSimpleData(newSimpleData)).subscribeOn(Schedulers.io()).subscribe());
    }

    @Override
    public void updateInsuranceData(@Nullable InsuranceData newInsuranceData) {
        Completable.fromAction(() -> this._updateInsuranceData(newInsuranceData)).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    @NotNull
    public BuyingProcess.State<BuyingProcessImpl> getState() {
        this.state.authState = this.authService.getState();
        return this.state;
    }

    @Override
    public void resetOsago() throws Exception {
        this.state.simpleData = null;
        this.state.insuranceRate = null;
        this.state.insuranceData = null;
        this.state.deal = null;
        this.state.isCorrectUserType = null;
        this.state.documentsForCheck.clear();
        this.state.needUpdateDeal = true;
        this.state.uploadedPhoto = false;
        this.authService.reset();
        this.saveState();
    }

    @Override
    public void resetCasco() throws Exception {
        this.state.cascoData = null;
        this.saveState();
    }

    @Override
    public void restore() throws Exception {
        BuyingProcess.State state = this.restorationManager.getStateProcess();
        if (state == null) {
            return;
        }
        this.restore(state);
    }

    @Override
    public void restore(@NotNull BuyingProcess.State state) {
        if (!(state instanceof StateImpl)) {
            throw new IllegalArgumentException();
        }
        ((StateImpl)state).restore(this);
    }

    @NotNull
    private InsuranceRate _prePricing(@NotNull SimpleData data) throws Exception {
        this.checkConnection();
        if (this.state.simpleData != null && !this.state.simpleData.getPartialContact().getPhone().getValue().equals(data.getPartialContact().getPhone().getValue())) {
            this.resetOsago();
        }
        this.updateVehicleDetailsIfNeeded(data.getVehicle(), data.getCity());
        this.state.insuranceRate = this.apiGateway.prePricing(data);
        if (!data.equals(this.state.simpleData)) {
            this.state.simpleData = data;
            this.state.insuranceData = null;
            this.state.isCorrectUserType = null;
        }
        this.saveState();
        return this.state.insuranceRate;
    }

    @NotNull
    private InsuranceRate _pricing(@NotNull InsuranceData newInsuranceData) throws Exception {
        boolean needPricing;
        this.checkConnection();
        if (this.state.dcState == DiagnosticCardState.UNKNOWN && this._checkNeedDiagnosticCard(newInsuranceData.getVehicleDocument(), newInsuranceData.getConditions().getEffectiveDate())) {
            throw new NeedDiagnosticCardException();
        }
        newInsuranceData.getInsurer().setPhone(this.state.simpleData.getPartialContact().getPhone());
        boolean bl = needPricing = this.state.insuranceData == null || !newInsuranceData.equals(this.state.insuranceData);
        if (needPricing) {
            this.state.insuranceRate = this.apiGateway.pricing(this.state.simpleData, newInsuranceData);
            this.state.uploadedPhoto = false;
            this.state.needUpdateDeal = true;
            this.state.isCorrectUserType = null;
            this.state.documentsForCheck.clear();
            this.restorationManager.clearPhotosDocument();
            this.state.insuranceData = newInsuranceData;
        }
        if (this.state.isCorrectUserType == null) {
            this.state.isCorrectUserType = this.checkCorrectUserType();
        }
        if (!this.state.isCorrectUserType.booleanValue()) {
            throw new IncorrectUserTypeException(this.generateThirdPartyLink());
        }
        this.saveState();
        return this.state.insuranceRate;
    }

    private boolean _checkNeedDiagnosticCard(@NotNull VehicleDocument vehicleDocument, @NotNull Date effective) throws Exception {
        this.state.dcState = DiagnosticCardState.UNKNOWN;
        this.checkConnection();
        boolean need = this.apiGateway.diagnosticCard((Date)effective, (Vehicle)((StateImpl)this.state).simpleData.getVehicle(), (VehicleDocument)vehicleDocument).need;
        this.state.dcState = need ? DiagnosticCardState.NEED : DiagnosticCardState.NOT_NEED;
        this.saveState();
        return need;
    }

    private void _updateDeal() throws Exception {
        this.checkConnection();
        String dealId = null;
        if (this.state.deal != null) {
            dealId = this.state.deal.getId();
        }
        if (this.state.deal == null || this.state.needUpdateDeal) {
            this.authService.ping();
            this.state.deal = this.apiGateway.updateDeal(this.authService.getAccessToken(), this.state.simpleData, this.state.insuranceData, dealId);
            this.state.needUpdateDeal = false;
        }
        this.checkNeedScanDocs();
        this.saveState();
        List<Scan> needScanDocs = this.getNeedPhotosDocuments();
        if (!needScanDocs.isEmpty() && !this.state.uploadedPhoto) {
            throw new NeedScansException();
        }
    }

    @NotNull
    private Deal buy() throws Exception {
        if (!this.state.deal.isPaymentOrderCompleted()) {
            this.checkConnection();
            this.authService.ping();
            Callable<Boolean> completeDeal = () -> this.apiGateway.completeDeal(this.authService.getAccessToken(), this.state.deal, this.state.insuranceData, this.state.insuranceRate.getKbm());
            try {
                if (!this.state.deal.isCompleted() && !completeDeal.call().booleanValue()) {
                    throw new IllegalStateException("Unable to complete deal");
                }
                this.state.deal.complete();
                this.apiGateway.paymentOrder(this.authService.getAccessToken(), this.state.deal);
                this.saveState();
            }
            catch (CompleteException e) {
                switch (e.getResultCode()) {
                    case "Expired": 
                    case "Canceled": {
                        this.resetIds();
                        this.saveState();
                    }
                }
                throw e;
            }
        }
        return this.state.deal;
    }

    private void _uploadScanDocuments(@NotNull Map<Scan, List<File>> photosDocuments) throws Exception {
        this.checkConnection();
        this.authService.ping();
        HashMap<Scan, List<FileInfo>> uploadedFiles = new HashMap<Scan, List<FileInfo>>(photosDocuments.size());
        for (Scan scan : photosDocuments.keySet()) {
            List<FileInfo> list = this.apiGateway.uploadFile(photosDocuments.get(scan));
            uploadedFiles.put(scan, list);
        }
        ArrayList<QuoteSet.ScanDocument> listScanDocument = new ArrayList<QuoteSet.ScanDocument>();
        for (Map.Entry entry : uploadedFiles.entrySet()) {
            if (((List)entry.getValue()).size() > 2) {
                throw new IllegalArgumentException(String.format("%s can not contain more than two scans.", entry.toString()));
            }
            for (FileInfo fileInfo : (List)entry.getValue()) {
                listScanDocument.add(this.createScanDocument((Scan)entry.getKey(), fileInfo));
            }
        }
        QuoteSet quoteSet = new QuoteSet(this.state.deal.getQuoteNumber(), this.state.insuranceData.getInsurer().getPhone().getValue(), listScanDocument.toArray(new QuoteSet.ScanDocument[listScanDocument.size()]));
        this.apiGateway.loadDocument(this.authService.getAccessToken(), quoteSet);
        this.state.documentsForCheck.clear();
        this.state.uploadedPhoto = true;
        this.saveState();
    }

    private void _sendCode() throws Exception {
        this.checkConnection();
        this.authService.smsCode(this.state.simpleData.getPartialContact().getPhone());
        this.saveState();
    }

    private void _setCode(@NotNull String code) throws Exception {
        this.checkConnection();
        this.authService.signUp(code);
        this.saveState();
    }

    private void _updateSimpleData(@Nullable SimpleData newSimpleData) throws Exception {
        if (!(this.state.simpleData == null || newSimpleData != null && this.state.simpleData.equalsExceptDetails(newSimpleData))) {
            this.state.insuranceRate = null;
            this.saveState();
        }
    }

    private void _updateInsuranceData(@Nullable InsuranceData newInsuranceData) throws Exception {
        if (!(this.state.insuranceData == null || newInsuranceData != null && this.state.insuranceData.equals(newInsuranceData))) {
            this.state.isCorrectUserType = null;
            this.saveState();
        }
        if (newInsuranceData != null && this.state.newInsuranceData != null && !newInsuranceData.getVehicleDocument().getVin().equals(this.state.newInsuranceData.getVehicleDocument().getVin())) {
            this.checkNeedDiagnosticCard(newInsuranceData.getVehicleDocument(), newInsuranceData.getConditions().getEffectiveDate());
        }
        this.state.newInsuranceData = newInsuranceData;
    }

    private void resetIds() {
        if (this.state.deal != null) {
            this.state.deal.reset();
        }
        if (this.state.insuranceData != null) {
            Insurer insurer = this.state.insuranceData.getInsurer();
            insurer.setId(null);
            insurer.getRegisteredAddress().setId(null);
            insurer.getHomeAddress().setId(null);
            Contact owner = this.state.insuranceData.getOwner();
            owner.setId(null);
            owner.getRegisteredAddress().setId(null);
            owner.getHomeAddress().setId(null);
            Drivers drivers = this.state.insuranceData.getDrivers();
            if (!drivers.isMultiple()) {
                for (Driver driver : drivers.getDrivers()) {
                    driver.setId(null);
                }
            }
        }
    }

    private void updateVehicleDetailsIfNeeded(@NotNull Vehicle vehicle, @NotNull City city) throws Exception {
        if (!vehicle.isDetailsInitialized()) {
            VehicleDetails details = this.apiGateway.queryVehicleDetails(vehicle.getModelId(), vehicle.getYear(), vehicle.getCaseAndDoorsId(), vehicle.getEngineId(), vehicle.getKppId(), CommonUtils.getRegionFromKladr(city.getRegionKladr()));
            vehicle.setDetails(details);
        }
    }

    @NotNull
    private QuoteSet.ScanDocument createScanDocument(@NotNull Scan scan, @NotNull FileInfo fileInfo) {
        String documentType;
        String seriesNumber = null;
        switch (scan.getType()) {
            case PASSPORT: {
                documentType = "Passport";
                break;
            }
            case DRIVER_LICENCE: {
                documentType = "DrivingLicense";
                seriesNumber = this.getSeriesNumberDriverLicense(scan.getSubjectNumber());
                break;
            }
            case DOCUMENTS_CAR: {
                documentType = VehicleDocument.TypeDocument.PTS == this.getVehicleDocumentType() ? "PTS" : "STS";
                break;
            }
            case TECH_CARD: {
                documentType = "TechCard";
                break;
            }
            default: {
                throw new IllegalArgumentException("Scan documentType is not found");
            }
        }
        long id = fileInfo.getId();
        String extension = fileInfo.getExtension();
        this.state.deal.removeScanNeeds();
        return new QuoteSet.ScanDocument(documentType, seriesNumber, id, extension);
    }

    private boolean checkCorrectUserType() throws Exception {
        if (this.state.simpleData == null || this.state.insuranceRate == null || this.state.insuranceData == null) {
            throw this.generateStateException();
        }
        return CLIENT_TYPE_DEFAULT.equals(this.apiGateway.checkUserType(this.state.insuranceData, this.state.simpleData.getVehicle(), this.state.insuranceRate));
    }

    @NotNull
    private String generateThirdPartyLink() {
        try {
            return this.apiGateway.createSravniRuCalculation(this.state.insuranceData, this.state.simpleData.getVehicle()).getLink();
        }
        catch (Exception e) {
            return SravniRuCalcInfo.getDefaultLink();
        }
    }

    @NotNull
    private String getSeriesNumberDriverLicense(int subjectNumber) {
        Driver driver = this.state.insuranceData.getDrivers().getDriver(subjectNumber);
        if (driver != null) {
            return driver.getDriverLicense().getSeriesNumber();
        }
        throw this.generateStateException();
    }

    @Override
    @NotNull
    public List<Scan> getNeedPhotosDocuments() {
        return this.state.documentsForCheck;
    }

    private void checkNeedScanDocs() {
        InsuranceConditions conditions;
        if (!this.state.deal.isNeedScan()) {
            this.state.documentsForCheck.clear();
            return;
        }
        this.state.documentsForCheck.clear();
        this.state.documentsForCheck.add(new Scan(-1, Scan.Type.DOCUMENTS_CAR));
        this.state.documentsForCheck.add(new Scan(1, Scan.Type.PASSPORT));
        Drivers drivers = this.state.insuranceData.getDrivers();
        if (!drivers.isMultiple() && drivers.getDrivers() != null) {
            for (Driver driver : drivers.getDrivers()) {
                this.state.documentsForCheck.add(new Scan(driver.getSubjectNumber(), Scan.Type.DRIVER_LICENCE));
            }
        }
        if (!StringUtilsKt.isEmpty((conditions = this.state.insuranceData.getConditions()).getNumberDC())) {
            this.state.documentsForCheck.add(new Scan(-1, Scan.Type.TECH_CARD));
        }
    }

    private void checkConnection() {
        if (!this.connectivityChecker.isConnectionAvailable()) {
            throw new NotConnectedException();
        }
    }

    private void checkSimpleData() {
        Preconditions.checkState(this.state.simpleData != null, "You can't call this method, because You have not completed the calculation of the amount of insurance");
    }

    private void checkRate() {
        Preconditions.checkState(this.state.insuranceRate != null, "You can't call this method, because You have not completed the calculation of the amount of insurance");
    }

    private void checkInsuranceData() {
        Preconditions.checkState(this.state.insuranceData != null, "You can't call this method, because You have not completed the calculation of the amount of insurance");
    }

    private void checkDealData() {
        Preconditions.checkState(this.state.deal != null, "you cannot call this method because you have not made a deal");
    }

    private IllegalStateException generateStateException() {
        return new IllegalStateException("Necessary to pass the previous stage of the process");
    }

    private void saveState() throws Exception {
        this.restorationManager.saveStateProcess(this.getState());
    }

    private static enum DiagnosticCardState {
        UNKNOWN,
        NEED,
        NOT_NEED;

    }

    private static class StateImpl
    implements BuyingProcess.State<BuyingProcessImpl> {
        private AuthService.State authState;
        private SimpleData simpleData;
        private InsuranceRate insuranceRate;
        private InsuranceData insuranceData;
        private InsuranceData newInsuranceData;
        private Deal deal;
        private CascoData cascoData;
        private Boolean isCorrectUserType;
        private boolean uploadedPhoto = false;
        private boolean needUpdateDeal = false;
        private DiagnosticCardState dcState = DiagnosticCardState.UNKNOWN;
        private final List<Scan> documentsForCheck = new ArrayList<Scan>();

        private StateImpl() {
        }

        @Override
        public void restore(@NotNull BuyingProcessImpl buyingProcess) {
            if (this.authState != null) {
                buyingProcess.authService.restore(this.authState);
            }
            buyingProcess.state = this;
        }
    }
}

