/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.DealResult;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class Deal
implements Serializable {
    private String id;
    private final String setNumber;
    private final DealResult result;
    private String quoteNumber;
    private boolean needScan;
    private boolean isCompleted;
    @Nullable
    private String orderId;
    @Nullable
    private Double paymentAmount;

    public Deal(@NotNull String id, @NotNull String setNumber, @NotNull DealResult result, boolean needScan, @NotNull String quoteNumber) {
        Preconditions.checkArgument(StringUtilsKt.isNotEmpty(id));
        Preconditions.checkArgument(StringUtilsKt.isNotEmpty(setNumber));
        Preconditions.checkArgument(StringUtilsKt.isNotEmpty(quoteNumber));
        Preconditions.checkNotNull(result);
        this.id = id;
        this.setNumber = setNumber;
        this.needScan = needScan;
        this.result = result;
        this.quoteNumber = quoteNumber;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getSetNumber() {
        return this.setNumber;
    }

    public boolean isNeedScan() {
        return this.needScan;
    }

    @NotNull
    public DealResult getResult() {
        return this.result;
    }

    @NotNull
    public String getQuoteNumber() {
        return this.quoteNumber;
    }

    @NotNull
    public String getOrderId() {
        if (this.orderId == null) {
            throw new IllegalArgumentException("\u0412\u044b\u0437\u043e\u0432 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0433\u0435\u0442\u0442\u0435\u0440\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043e\u043f\u043b\u0430\u0442\u044b payment order");
        }
        return this.orderId;
    }

    @NotNull
    public Double getPaymentAmount() {
        if (this.paymentAmount == null) {
            throw new IllegalArgumentException("\u0412\u044b\u0437\u043e\u0432 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0433\u0435\u0442\u0442\u0435\u0440\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043e\u043f\u043b\u0430\u0442\u044b payment order");
        }
        return this.paymentAmount;
    }

    public void setOrderId(@Nullable String orderId) {
        this.orderId = orderId;
    }

    public void setPaymentAmount(@Nullable Double paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public void removeScanNeeds() {
        this.needScan = false;
    }

    public boolean isPaymentOrderCompleted() {
        return this.paymentAmount != null && this.orderId != null;
    }

    public void complete() {
        this.isCompleted = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void reset() {
        this.id = null;
        this.isCompleted = false;
        this.orderId = null;
        this.paymentAmount = null;
    }

    public String toString() {
        return "Deal{id='" + this.id + '\'' + ", setNumber='" + this.setNumber + '\'' + ", result=" + this.result + ", quoteNumber='" + this.quoteNumber + '\'' + ", needScan=" + this.needScan + ", orderId='" + this.orderId + '\'' + ", paymentAmount=" + this.paymentAmount + '}';
    }
}

