/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class InsuranceConditions
implements Serializable {
    public static final int INSURANCE_DURATION_DAYS = 365;
    private static final int EFFECTIVE_DATE_DAY_LIMITER = 60;
    private static final int ONE_DAY = 1;
    private static final int EXPIRATION_DC_DATE_YEAR_LIMITER = 3;
    private static final String REGEXP_DC = "^([0-9]{15}|[0-9]{21})$";
    private static final String EMAIL_REGEXP = "^[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,64}$";
    private final String email;
    private final Date effectiveDate;
    private final Date expirationDate;
    private final String numberDC;
    private final Date expirationDC;

    public static boolean validateEmail(@Nullable String email) {
        if (StringUtilsKt.isEmpty(email)) {
            return false;
        }
        Matcher matcher = Pattern.compile(EMAIL_REGEXP).matcher(email);
        return matcher.matches();
    }

    public static boolean validateEffectiveDate(@Nullable Date effectiveDate) {
        if (effectiveDate == null) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        if (effectiveDate.compareTo(new Date()) <= 0) {
            return false;
        }
        c.setTime(new Date());
        c.add(5, 60);
        return effectiveDate.compareTo(c.getTime()) <= 0;
    }

    public static boolean validateDC(@Nullable String numberDC) {
        if (StringUtilsKt.isEmpty(numberDC)) {
            return false;
        }
        Matcher matcher = Pattern.compile(REGEXP_DC).matcher(numberDC);
        return matcher.matches();
    }

    public static boolean validateExpirationDC(@Nullable Date expirationDC, @Nullable Date effectiveDate) {
        if (expirationDC == null) {
            return false;
        }
        if (effectiveDate != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(effectiveDate);
            c.add(5, 1);
            if (expirationDC.compareTo(c.getTime()) <= 0) {
                return false;
            }
            c.setTime(new Date());
            c.add(1, 3);
            return expirationDC.compareTo(c.getTime()) <= 0;
        }
        return true;
    }

    public InsuranceConditions(@NotNull Date effectiveDate, @NotNull Date expirationDate, @NotNull String email) {
        this.checkEffectiveDate(effectiveDate);
        this.effectiveDate = effectiveDate;
        this.expirationDate = expirationDate;
        this.checkEmail(email);
        this.email = email;
        this.numberDC = null;
        this.expirationDC = null;
    }

    public InsuranceConditions(@NotNull Date effectiveDate, @NotNull Date expirationDate, @NotNull String email, @NotNull String numberDC, @NotNull Date expirationDC) {
        this.checkEffectiveDate(effectiveDate);
        this.effectiveDate = effectiveDate;
        this.expirationDate = expirationDate;
        this.checkEmail(email);
        this.email = email;
        this.checkNumberDC(numberDC);
        this.numberDC = numberDC;
        this.checkExpirationDC(expirationDC, effectiveDate);
        this.expirationDC = expirationDC;
    }

    @NotNull
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @NotNull
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public String getNumberDC() {
        return this.numberDC;
    }

    @Nullable
    public Date getExpirationDC() {
        return this.expirationDC;
    }

    @NotNull
    public String getEmail() {
        return this.email;
    }

    private void checkEmail(String email) {
        if (!InsuranceConditions.validateEmail(email)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkEffectiveDate(Date effectiveDate) {
        if (!InsuranceConditions.validateEffectiveDate(effectiveDate)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkNumberDC(String numberDC) {
        if (!InsuranceConditions.validateDC(numberDC)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkExpirationDC(Date expirationDC, Date effectiveDate) {
        if (!InsuranceConditions.validateExpirationDC(expirationDC, effectiveDate)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsuranceConditions that = (InsuranceConditions)o;
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.effectiveDate != null ? !this.effectiveDate.equals(that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (this.expirationDate != null ? !this.expirationDate.equals(that.expirationDate) : that.expirationDate != null) {
            return false;
        }
        if (this.numberDC != null ? !this.numberDC.equals(that.numberDC) : that.numberDC != null) {
            return false;
        }
        return this.expirationDC != null ? this.expirationDC.equals(that.expirationDC) : that.expirationDC == null;
    }

    public int hashCode() {
        int result = this.email != null ? this.email.hashCode() : 0;
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
        result = 31 * result + (this.numberDC != null ? this.numberDC.hashCode() : 0);
        result = 31 * result + (this.expirationDC != null ? this.expirationDC.hashCode() : 0);
        return result;
    }
}

