/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.InsuranceConditions;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Drivers;
import ru.tinkoff.tisdk.subject.Insurer;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class InsuranceData
implements Serializable {
    private final VehicleDocument vehicleDocument;
    private final Insurer insurer;
    private final Contact owner;
    private final Drivers drivers;
    private final InsuranceConditions conditions;

    public InsuranceData(@NotNull VehicleDocument vehicleDocument, @NotNull Insurer insurer, @NotNull Contact owner, @NotNull Drivers drivers, @NotNull InsuranceConditions conditions) {
        this.vehicleDocument = Preconditions.checkNotNull(vehicleDocument);
        this.insurer = Preconditions.checkNotNull(insurer);
        this.owner = Preconditions.checkNotNull(owner);
        this.drivers = Preconditions.checkNotNull(drivers);
        this.conditions = Preconditions.checkNotNull(conditions);
    }

    @NotNull
    public VehicleDocument getVehicleDocument() {
        return this.vehicleDocument;
    }

    @NotNull
    public Insurer getInsurer() {
        return this.insurer;
    }

    @NotNull
    public Contact getOwner() {
        return this.owner;
    }

    @NotNull
    public Drivers getDrivers() {
        return this.drivers;
    }

    @NotNull
    public InsuranceConditions getConditions() {
        return this.conditions;
    }

    @Nullable
    public String getStsNumber() {
        if (this.vehicleDocument.getTypeDocument() == VehicleDocument.TypeDocument.STS) {
            return this.vehicleDocument.getSeriesNumber();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsuranceData that = (InsuranceData)o;
        if (!this.vehicleDocument.equals(that.vehicleDocument)) {
            return false;
        }
        if (!this.insurer.equals(that.insurer)) {
            return false;
        }
        if (!this.owner.equals(that.owner)) {
            return false;
        }
        if (!this.drivers.equals(that.drivers)) {
            return false;
        }
        return this.conditions.equals(that.conditions);
    }

    public int hashCode() {
        int result = this.vehicleDocument.hashCode();
        result = 31 * result + this.insurer.hashCode();
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + this.drivers.hashCode();
        result = 31 * result + this.conditions.hashCode();
        return result;
    }
}

