/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.address;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.address.City;
import ru.tinkoff.tisdk.utils.Preconditions;

public class Address
extends City {
    private String id;
    private final String postCode;
    private final String street;
    private final String building;
    private final String flat;
    private final String block;
    private final String streetKladr;
    private final String buildingKladr;
    private final Type type;

    public Address(@NotNull Type type, @NotNull String address, @NotNull String regionKladr, @NotNull String cityKladr, @NotNull String streetKladr, @Nullable String buildingKladr, @NotNull String city, @NotNull String postCode, @NotNull String street, @NotNull String building, @Nullable String flat, @Nullable String block, @Nullable String populatedCenter, @Nullable String populatedCenterKladr) {
        super(address, city, populatedCenter, populatedCenterKladr, regionKladr, cityKladr);
        Preconditions.checkNotNull(type);
        this.checkStreetKladr(streetKladr);
        this.checkPostCode(postCode);
        this.checkStreet(street);
        this.checkBuilding(building);
        this.type = type;
        this.streetKladr = streetKladr;
        this.buildingKladr = buildingKladr;
        this.postCode = postCode;
        this.street = street;
        this.building = building;
        this.flat = flat;
        this.block = block;
    }

    public void setId(String id) {
        this.id = id;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public String getStreetKladr() {
        return this.streetKladr;
    }

    @NotNull
    public String getBuildingKladr() {
        return this.buildingKladr;
    }

    @NotNull
    public String getPostCode() {
        return this.postCode;
    }

    @NotNull
    public String getStreet() {
        return this.street;
    }

    @NotNull
    public String getFormattedBuilding() {
        if (this.block != null) {
            return this.building + " " + this.block;
        }
        return this.building;
    }

    @NotNull
    public String getBuilding() {
        return this.building;
    }

    @Nullable
    public String getFlat() {
        return this.flat;
    }

    @Nullable
    public String getBlock() {
        return this.block;
    }

    private void checkStreetKladr(String kladr5) {
        if (!Address.validateAddress(kladr5)) {
            throw new AddressException();
        }
    }

    private void checkPostCode(String postCode) {
        if (!Address.validateAddress(postCode)) {
            throw new AddressException();
        }
    }

    private void checkStreet(String street) {
        if (!Address.validateAddress(street)) {
            throw new AddressException();
        }
    }

    private void checkBuilding(String building) {
        if (!Address.validateAddress(building)) {
            throw new AddressException();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.equalsIgnoreType(address) && this.type == address.type;
    }

    public boolean equalsIgnoreType(Address address) {
        if (this.getPopulatedCenterKladr() != null ? !this.getPopulatedCenterKladr().equals(address.getPopulatedCenterKladr()) : address.getPopulatedCenterKladr() != null) {
            return false;
        }
        if (this.getPopulatedCenter() != null ? !this.getPopulatedCenter().equals(address.getPopulatedCenter()) : address.getPopulatedCenter() != null) {
            return false;
        }
        if (this.getCityKladr() != null ? !this.getCityKladr().equals(address.getCityKladr()) : address.getCityKladr() != null) {
            return false;
        }
        if (this.getCity() != null ? !this.getCity().equals(address.getCity()) : address.getCity() != null) {
            return false;
        }
        if (this.postCode != null ? !this.postCode.equals(address.postCode) : address.postCode != null) {
            return false;
        }
        if (this.street != null ? !this.street.equals(address.street) : address.street != null) {
            return false;
        }
        if (this.building != null ? !this.building.equals(address.building) : address.building != null) {
            return false;
        }
        if (this.flat != null ? !this.flat.equals(address.flat) : address.flat != null) {
            return false;
        }
        if (this.block != null ? !this.block.equals(address.block) : address.block != null) {
            return false;
        }
        if (this.streetKladr != null ? !this.streetKladr.equals(address.streetKladr) : address.streetKladr != null) {
            return false;
        }
        return this.buildingKladr != null ? this.buildingKladr.equals(address.buildingKladr) : address.buildingKladr == null;
    }

    @Override
    public int hashCode() {
        int result = this.postCode != null ? this.postCode.hashCode() : 0;
        result = 31 * result + (this.getCity() != null ? this.getCity().hashCode() : 0);
        result = 31 * result + (this.getCityKladr() != null ? this.getCityKladr().hashCode() : 0);
        result = 31 * result + (this.getPopulatedCenter() != null ? this.getPopulatedCenter().hashCode() : 0);
        result = 31 * result + (this.getPopulatedCenterKladr() != null ? this.getPopulatedCenterKladr().hashCode() : 0);
        result = 31 * result + (this.street != null ? this.street.hashCode() : 0);
        result = 31 * result + (this.building != null ? this.building.hashCode() : 0);
        result = 31 * result + (this.flat != null ? this.flat.hashCode() : 0);
        result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
        result = 31 * result + (this.streetKladr != null ? this.streetKladr.hashCode() : 0);
        result = 31 * result + (this.buildingKladr != null ? this.buildingKladr.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static enum Type {
        REGISTER,
        HOME;

    }

    public static class AddressException
    extends IllegalArgumentException {
    }
}

