/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.address;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class City
implements Serializable {
    private final String address;
    private final String city;
    private final String populatedCenter;
    private final String populatedCenterKladr;
    private final String regionKladr;
    private final String cityKladr;

    public static boolean validateAddress(@Nullable String address) {
        return !StringUtilsKt.isEmpty(address);
    }

    public City(@NotNull String address, @Nullable String city, @Nullable String populatedCenter, @Nullable String populatedCenterKladr, @NotNull String regionKladr, @Nullable String cityKladr) {
        this.checkAddress(address);
        this.address = address;
        this.checkCity(city, populatedCenter);
        this.city = city;
        this.populatedCenter = populatedCenter;
        this.checkKladr(regionKladr);
        this.regionKladr = regionKladr;
        this.checkKladr(cityKladr, populatedCenterKladr);
        this.cityKladr = cityKladr;
        this.populatedCenterKladr = populatedCenterKladr;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    @NotNull
    public String getRegionKladr() {
        return this.regionKladr;
    }

    @Nullable
    public String getCityKladr() {
        return this.cityKladr;
    }

    @Nullable
    public String getPopulatedCenter() {
        return this.populatedCenter;
    }

    @Nullable
    public String getPopulatedCenterKladr() {
        return this.populatedCenterKladr;
    }

    @NotNull
    public String getRegion() {
        return this.city;
    }

    @Nullable
    public String getCity() {
        return this.city;
    }

    private void checkAddress(String address) {
        if (!City.validateAddress(address)) {
            throw new Address.AddressException();
        }
    }

    private void checkKladr(String kladr) {
        if (!City.validateAddress(kladr)) {
            throw new Address.AddressException();
        }
    }

    private void checkKladr(String cityKladr, String settlementKladr) {
        if (!City.validateAddress(cityKladr) && !City.validateAddress(settlementKladr)) {
            throw new Address.AddressException();
        }
    }

    private void checkCity(String city, String settlement) {
        if (!City.validateAddress(city) && !City.validateAddress(settlement)) {
            throw new Address.AddressException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        City city1 = (City)o;
        if (this.address != null ? !this.address.equals(city1.address) : city1.address != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(city1.city) : city1.city != null) {
            return false;
        }
        if (this.populatedCenter != null ? !this.populatedCenter.equals(city1.populatedCenter) : city1.populatedCenter != null) {
            return false;
        }
        if (this.populatedCenterKladr != null ? !this.populatedCenterKladr.equals(city1.populatedCenterKladr) : city1.populatedCenterKladr != null) {
            return false;
        }
        if (this.regionKladr != null ? !this.regionKladr.equals(city1.regionKladr) : city1.regionKladr != null) {
            return false;
        }
        return this.cityKladr != null ? this.cityKladr.equals(city1.cityKladr) : city1.cityKladr == null;
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.populatedCenter != null ? this.populatedCenter.hashCode() : 0);
        result = 31 * result + (this.populatedCenterKladr != null ? this.populatedCenterKladr.hashCode() : 0);
        result = 31 * result + (this.regionKladr != null ? this.regionKladr.hashCode() : 0);
        result = 31 * result + (this.cityKladr != null ? this.cityKladr.hashCode() : 0);
        return result;
    }
}

