/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.auth;

import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.AuthData;
import ru.tinkoff.tisdk.auth.AuthService;
import ru.tinkoff.tisdk.auth.UnAuthorizedException;
import ru.tinkoff.tisdk.carreference.gateway.common.exception.GatewayException;
import ru.tinkoff.tisdk.subject.Phone;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class AuthServiceImpl
implements AuthService {
    private final ApiGateway apiGateway;
    private String deviceId;
    private AuthData authData;
    private String unconfirmedToken;

    public AuthServiceImpl(@NotNull ApiGateway apiGateway, @NotNull String deviceId) {
        if (apiGateway == null) {
            throw new NullPointerException();
        }
        this.apiGateway = apiGateway;
        if (deviceId == null) {
            throw new NullPointerException();
        }
        this.deviceId = deviceId;
    }

    @Override
    public void smsCode(@NotNull Phone phone) throws Exception {
        this.unconfirmedToken = this.apiGateway.smsCode(phone, this.deviceId);
    }

    @Override
    public void signUp(@NotNull String password) throws Exception {
        if (StringUtilsKt.isEmpty(this.unconfirmedToken)) {
            throw new IllegalStateException("first call smsCode() method");
        }
        this.authData = this.apiGateway.signUp(this.unconfirmedToken, password);
    }

    @Override
    public void ping() throws Exception {
        if (this.authData == null) {
            throw new UnAuthorizedException();
        }
        try {
            this.apiGateway.ping(this.authData.getAccessToken());
        }
        catch (GatewayException e) {
            if (e.isTokenExpired() || e.isTokenWrong() || e.isUnAuthorized()) {
                this.signIn();
            }
            throw new UnAuthorizedException(e);
        }
        catch (Exception e) {
            throw new UnAuthorizedException(e);
        }
    }

    @Override
    public void signIn() throws Exception {
        if (this.authData == null) {
            throw new UnAuthorizedException();
        }
        try {
            this.authData = this.apiGateway.signIn(this.authData.getRefreshToken(), this.deviceId);
        }
        catch (GatewayException e) {
            throw new UnAuthorizedException(e);
        }
    }

    @Override
    @NotNull
    public AuthService.State getState() {
        return new StateImpl(this.authData, this.unconfirmedToken, this.deviceId);
    }

    @Override
    public void reset() {
        this.authData = null;
        this.unconfirmedToken = null;
    }

    @Override
    @NotNull
    public String getAccessToken() {
        if (this.authData == null) {
            throw new UnAuthorizedException();
        }
        return this.authData.getAccessToken();
    }

    @Override
    public void restore(@NotNull AuthService.State state) {
        if (!(state instanceof StateImpl)) {
            throw new IllegalArgumentException();
        }
        ((StateImpl)state).restore(this);
    }

    private static class StateImpl
    implements AuthService.State<AuthServiceImpl> {
        private AuthData authData;
        private String token;
        private String deviceId;

        StateImpl(AuthData authData, String token, String deviceId) {
            this.authData = authData;
            this.token = token;
            this.deviceId = deviceId;
        }

        @Override
        public void restore(@NotNull AuthServiceImpl authService) {
            authService.authData = this.authData;
            authService.unconfirmedToken = this.token;
            authService.deviceId = this.deviceId;
        }
    }
}

