/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.carreference.gateway.common.convertion;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.ServerResponse;
import ru.tinkoff.tisdk.carreference.gateway.common.exception.GatewayException;
import ru.tinkoff.tisdk.carreference.gateway.common.exception.ValidationException;
import ru.tinkoff.tisdk.carreference.gateway.common.model.GServerErrorValidation;

public abstract class Converter<T, S> {
    @NotNull
    protected abstract ServerResponse<S> parse(@NotNull String var1) throws Exception;

    @NotNull
    protected abstract T convertPayload(@NotNull ServerResponse<S> var1) throws Exception;

    @NotNull
    public final T convert(@NotNull String json) throws Exception {
        ServerResponse<S> response = this.parse(json);
        this.checkErrors(response);
        return this.convertPayload(response);
    }

    @NotNull
    protected GatewayException createException(@NotNull String id, @NotNull String domain, @NotNull String resultCode, @NotNull String userMessage) {
        return new GatewayException(id, domain, resultCode, userMessage);
    }

    private void checkErrors(@NotNull ServerResponse<S> response) throws Exception {
        if (response.getError() != null && response.getErrorId() != null) {
            if (response.getError().ValidationErrors != null) {
                throw this.createValidationException(response.getErrorId(), response.getError().Domain, response.getError().ResultCode, response.getError().UserMessage, response.getError().ValidationErrors);
            }
            throw this.createException(response.getErrorId(), response.getError().Domain, response.getError().ResultCode, response.getError().UserMessage);
        }
        if (response.getPayload() == null || !"OK".equalsIgnoreCase(response.getResultCode())) {
            throw new Exception();
        }
    }

    private ValidationException createValidationException(@NotNull String id, @NotNull String domain, @NotNull String resultCode, @NotNull String userMessage, @NotNull List<GServerErrorValidation> GServerErrorValidations) {
        ArrayList<String> validationCodes = new ArrayList<String>();
        for (GServerErrorValidation gServerErrorValidation : GServerErrorValidations) {
            validationCodes.add(gServerErrorValidation.ResultCode);
        }
        return new ValidationException(id, domain, resultCode, userMessage, validationCodes);
    }
}

