/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.casco;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.subject.PartialContact;
import ru.tinkoff.tisdk.subject.Phone;
import ru.tinkoff.tisdk.subject.Subject;

public class CascoContact
extends PartialContact
implements Serializable {
    private final String lastName;
    private final String middleName;
    private final String firstName;

    public CascoContact(@NotNull Phone phone, @NotNull String fio) {
        super(phone);
        this.checkName(fio);
        String[] names = Subject.splitFio(fio);
        this.lastName = names[0];
        this.firstName = names[1];
        this.middleName = names[2];
    }

    @NotNull
    public String getLastName() {
        return this.lastName;
    }

    @NotNull
    public String getMiddleName() {
        return this.middleName;
    }

    @NotNull
    public String getFirstName() {
        return this.firstName;
    }

    @NotNull
    public String getFio() {
        return this.lastName + " " + this.firstName + " " + this.middleName;
    }

    private void checkName(String fio) {
        if (!Subject.validateFio(fio)) {
            throw new IllegalArgumentException();
        }
    }
}

