/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway;

import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.Converter;
import ru.tinkoff.tisdk.gateway.Config;
import ru.tinkoff.tisdk.gateway.model.FileRequestBody;

public abstract class BaseGateway {
    private static final String BASE_URL_INSURANCE = Config.getBaseUrlInsurance();
    private static final int HOST_PORT_INSURANCE = Config.getInsurancePort();
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String MULTIPART_VALUE_NAME = "file";
    protected static final String KEY_ORIGIN = "origin";
    protected static final String VALUE_ORIGIN = Config.getOrigin();
    private final OkHttpClient httpClient;

    public BaseGateway(@NotNull OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected <T> T requestPost(@NotNull String method, @NotNull ParamsBuilder builder, @NotNull Converter<T, ?> parsePayload) throws Exception {
        return this.requestPost(method, builder.buildBodyParams(), null, builder.buildQueryParams(), parsePayload);
    }

    protected <T> T requestPost(@NotNull String method, @NotNull ParamsBuilder builder, @Nullable String accessToken, @NotNull Converter<T, ?> parsePayload) throws Exception {
        return this.requestPost(method, builder.buildBodyParams(), accessToken, builder.buildQueryParams(), parsePayload);
    }

    protected <T> T requestPost(@NotNull String method, @NotNull String params, @Nullable String accessToken, @Nullable Map<String, String> queryParams, @NotNull Converter<T, ?> parsePayload) throws Exception {
        return this.requestPost(method, this.getRequestBody(params), accessToken, queryParams, parsePayload);
    }

    protected <T> T requestPost(@NotNull String method, @NotNull RequestBody requestBody, @Nullable String accessToken, @Nullable Map<String, String> queryParams, @NotNull Converter<T, ?> parsePayload) throws Exception {
        Request request = this.getPostRequest(method, requestBody, queryParams, accessToken);
        return this.request(request, parsePayload);
    }

    protected <T> T requestGet(@NotNull String method, @Nullable Map<String, String> params, @NotNull Converter<T, ?> parsePayload) throws Exception {
        return this.requestGet(method, params, null, parsePayload);
    }

    protected <T> T requestGet(@NotNull String method, @Nullable Map<String, String> params, @Nullable String accessToken, @NotNull Converter<T, ?> parsePayload) throws Exception {
        Request request = this.getGetRequest(method, params, accessToken);
        return this.request(request, parsePayload);
    }

    protected <T> T request(@NotNull Request request, @NotNull Converter<T, ?> converter) throws Exception {
        String response = this.executeRequest(request);
        return converter.convert(response);
    }

    @NotNull
    protected RequestBody getRequestBody(@NotNull String body) {
        return RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)body);
    }

    @NotNull
    protected MultipartBody getMultipartBodyFile(@NotNull List<FileRequestBody> files) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (FileRequestBody file : files) {
            builder.addFormDataPart(MULTIPART_VALUE_NAME, file.getFileName(), (RequestBody)file);
        }
        return builder.build();
    }

    protected abstract void addAuthorizationHeader(@Nullable String var1, @NotNull Request.Builder var2);

    @NotNull
    protected HttpUrl getRequestUrl(@NotNull String pathSegment, @Nullable Map<String, String> queryParams) {
        return this.getRequestUrl(pathSegment, queryParams, BASE_URL_INSURANCE, HOST_PORT_INSURANCE);
    }

    @NotNull
    protected HttpUrl getRequestUrl(@NotNull String pathSegment, @Nullable Map<String, String> queryParams, @NotNull String baseUrl, int port) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)baseUrl).newBuilder().addEncodedPathSegments(pathSegment).addQueryParameter(KEY_ORIGIN, VALUE_ORIGIN);
        if (port > 0) {
            urlBuilder.port(port);
        }
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                urlBuilder.addQueryParameter(key, queryParams.get(key));
            }
        }
        return urlBuilder.build();
    }

    @NotNull
    private Request getPostRequest(@NotNull String pathSegment, @Nullable RequestBody requestBody, @Nullable Map<String, String> queryParams, @Nullable String accessToken) {
        HttpUrl httpUrl = this.getRequestUrl(pathSegment, queryParams);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).post(requestBody);
        this.addAuthorizationHeader(accessToken, requestBuilder);
        return requestBuilder.build();
    }

    @NotNull
    private Request getGetRequest(@NotNull String pathSegment, @Nullable Map<String, String> queryParams, @Nullable String accessToken) {
        HttpUrl httpUrl = this.getRequestUrl(pathSegment, queryParams);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        this.addAuthorizationHeader(accessToken, requestBuilder);
        return requestBuilder.build();
    }

    @NotNull
    private String executeRequest(Request request) throws Exception {
        return this.httpClient.newCall(request).execute().body().string();
    }
}

