/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.InsuranceData;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.gateway.model.GCheckUserModel;
import ru.tinkoff.tisdk.utils.CommonUtils;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.vehicle.Vehicle;

public class CheckUserTypeParamsBuilder
extends ParamsBuilder {
    private static final String MARK_MODEL_FORMAT = "%s-%s";
    private InsuranceData data;
    private Vehicle vehicle;
    private InsuranceRate insuranceRate;

    public CheckUserTypeParamsBuilder(@NotNull InsuranceData data, @NotNull Vehicle vehicle, @NotNull InsuranceRate insuranceRate) {
        this.data = data;
        this.vehicle = vehicle;
        this.insuranceRate = insuranceRate;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        return new Gson().toJson((Object)new GCheckUserModel(this.data.getInsurer().getPhone().getValue(), DateUtils.formatDate(this.data.getConditions().getEffectiveDate()), this.vehicle.getYear(), String.format(MARK_MODEL_FORMAT, this.vehicle.getMakeName(), this.vehicle.getModelName()), this.data.getVehicleDocument().getVin(), this.data.getVehicleDocument().getLicensePlate(), this.data.getStsNumber(), this.data.getDrivers().getLicense(), CommonUtils.getRegionFromKladr(this.data.getOwner().getRegisteredAddress().getRegionKladr()), this.insuranceRate.getKbm(), 365, this.insuranceRate.getTotalPremium()));
    }

    @Override
    @Nullable
    public Map<String, String> buildQueryParams() throws Exception {
        return null;
    }
}

