/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.InsuranceData;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.gateway.model.GCompleteDealModel;
import ru.tinkoff.tisdk.utils.CommonUtils;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class CompleteDealParamsBuilder
extends ParamsBuilder {
    private final Deal deal;
    private final InsuranceData insuranceData;
    private final double kbm;

    public CompleteDealParamsBuilder(@NotNull Deal deal, @NotNull InsuranceData insuranceData, double kbm) {
        this.deal = deal;
        this.insuranceData = insuranceData;
        this.kbm = kbm;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        String sts = null;
        if (this.insuranceData.getVehicleDocument().getTypeDocument() == VehicleDocument.TypeDocument.STS && !StringUtilsKt.isEmpty(this.insuranceData.getVehicleDocument().getSeriesNumber())) {
            sts = this.insuranceData.getVehicleDocument().getSeriesNumber();
        }
        String dealId = Preconditions.checkNotNull(this.deal.getId());
        return new Gson().toJson((Object)new GCompleteDealModel(this.insuranceData.getVehicleDocument().getLicensePlate(), sts, this.insuranceData.getDrivers().getLicense(), CommonUtils.getRegionFromKladr(this.insuranceData.getOwner().getRegisteredAddress().getRegionKladr()), this.deal.getSetNumber(), dealId, this.insuranceData.getVehicleDocument().getVin(), this.insuranceData.getInsurer().getPhone().getValue(), this.deal.getResult().getTotalPremium(), this.kbm, 365));
    }

    @Override
    @Nullable
    public Map<String, String> buildQueryParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("IntegrationId", this.createIntegrationId());
        return params;
    }
}

