/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.vehicle.Vehicle;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class DiagnosticCardNeedParamsBuilder
extends ParamsBuilder {
    private static final String KEY_EFFECTIVE_DATE = "effectiveDate";
    private static final String KEY_VIN = "VIN";
    private static final String KEY_YEAR = "year";
    private static final String KEY_TRANSIT_TECH_INSPECTION = "isTransitForTechInspection";
    private static final String KEY_CATEGORY = "category";
    private static final String KEY_VEHICLE_TYPE = "vehicleType";
    private static final String KEY_VEHICLE_USAGE = "vehicleUsage";
    private static final String KEY_MAX_WEIGHT = "maxWeight";
    private static final String FORMAT_DATE_PARAM = "yyyy-MM-dd";
    private static final String DEFAULT_VALUE_CATEGORY_DRIVER = "B";
    private static final String DEFAULT_VALUE_VEHICLE_TYPE = "Car";
    private static final String DEFAULT_VALUE_VEHICLE_USAGE = "personal";
    private static final String DEFAULT_VALUE_MAX_WEIGHT = "3500";
    private Date effectiveDate;
    private Vehicle vehicle;
    private VehicleDocument vehicleDocument;

    public DiagnosticCardNeedParamsBuilder(@NotNull Date effective, @NotNull Vehicle vehicle, @NotNull VehicleDocument vehicleDocument) {
        this.effectiveDate = effective;
        this.vehicle = vehicle;
        this.vehicleDocument = vehicleDocument;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        return "";
    }

    @Override
    @Nullable
    public Map<String, String> buildQueryParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_DATE_PARAM, Locale.getDefault());
        params.put(KEY_EFFECTIVE_DATE, dateFormat.format(this.effectiveDate));
        params.put(KEY_VIN, this.vehicleDocument.getVin());
        params.put(KEY_YEAR, String.valueOf(this.vehicle.getYear()));
        params.put(KEY_TRANSIT_TECH_INSPECTION, String.valueOf(false));
        params.put(KEY_CATEGORY, DEFAULT_VALUE_CATEGORY_DRIVER);
        params.put(KEY_VEHICLE_TYPE, DEFAULT_VALUE_VEHICLE_TYPE);
        params.put(KEY_VEHICLE_USAGE, DEFAULT_VALUE_VEHICLE_USAGE);
        params.put(KEY_MAX_WEIGHT, DEFAULT_VALUE_MAX_WEIGHT);
        return params;
    }
}

