/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.InsuranceConditions;
import ru.tinkoff.tisdk.InsuranceData;
import ru.tinkoff.tisdk.SimpleData;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.gateway.model.GAddress;
import ru.tinkoff.tisdk.gateway.model.GContact;
import ru.tinkoff.tisdk.gateway.model.GContactPassport;
import ru.tinkoff.tisdk.gateway.model.GDriver;
import ru.tinkoff.tisdk.gateway.model.GDrivers;
import ru.tinkoff.tisdk.gateway.model.GMultidrive;
import ru.tinkoff.tisdk.gateway.model.GNamedDrivers;
import ru.tinkoff.tisdk.gateway.model.GOsagoQuote;
import ru.tinkoff.tisdk.gateway.model.GPassport;
import ru.tinkoff.tisdk.gateway.model.GPhone;
import ru.tinkoff.tisdk.gateway.model.GQuote;
import ru.tinkoff.tisdk.gateway.model.GSetDetails;
import ru.tinkoff.tisdk.gateway.model.GSimpleUpdateModel;
import ru.tinkoff.tisdk.gateway.model.GTechInspectionInfo;
import ru.tinkoff.tisdk.gateway.model.GVehicleDetails;
import ru.tinkoff.tisdk.gateway.model.GVehicleDocument;
import ru.tinkoff.tisdk.gateway.model.GVehicleLegalInfo;
import ru.tinkoff.tisdk.gateway.model.GVehicleReferenceDetails;
import ru.tinkoff.tisdk.gateway.model.GVehicleReferenceInfo;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.subject.Drivers;
import ru.tinkoff.tisdk.subject.Insurer;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.CommonUtils;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.StringUtilsKt;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class SimpleUpdateParamsBuilder
extends ParamsBuilder {
    private static final String KEY_RATE_ONLY = "rateOnly";
    protected SimpleData data;
    protected VehicleDocument vehicleDocument;
    protected Insurer insurer;
    protected Contact owner;
    protected Drivers drivers;
    protected InsuranceConditions conditions;
    private String dealId;

    public SimpleUpdateParamsBuilder(@NotNull SimpleData data, @NotNull InsuranceData insuranceData, @Nullable String dealId) {
        this.data = data;
        this.vehicleDocument = insuranceData.getVehicleDocument();
        this.insurer = insuranceData.getInsurer();
        this.owner = insuranceData.getOwner();
        this.drivers = insuranceData.getDrivers();
        this.conditions = insuranceData.getConditions();
        this.dealId = dealId;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        GDrivers gatewayDrivers;
        ArrayList<GContact> contacts = new ArrayList<GContact>();
        contacts.add(this.createContact(this.insurer, this.conditions));
        if (this.checkSamePerson(this.owner, this.insurer)) {
            this.owner.setSubjectNumber(this.insurer.getSubjectNumber());
        } else {
            contacts.add(this.createContact(this.owner));
        }
        if (this.drivers.isMultiple()) {
            gatewayDrivers = new GMultidrive();
        } else {
            ArrayList<GDriver> driversList = new ArrayList<GDriver>();
            if (this.drivers.getDrivers() != null) {
                for (Driver driver : this.drivers.getDrivers()) {
                    this.mergeDriver(contacts, driver);
                    driversList.add(this.createDriver(driver));
                }
            }
            gatewayDrivers = new GNamedDrivers(driversList.toArray(new GDriver[driversList.size()]));
        }
        return new Gson().toJson((Object)new GSimpleUpdateModel(contacts.toArray(new GContact[contacts.size()]), this.insurer.getSubjectNumber(), this.owner.getSubjectNumber(), new GSetDetails(new GOsagoQuote(new GQuote(gatewayDrivers, DateUtils.formatDate(this.conditions.getEffectiveDate()), DateUtils.formatDate(this.conditions.getExpirationDate()), this.insurer.getSubjectNumber(), this.owner.getSubjectNumber()))), new GVehicleDetails(new GVehicleReferenceInfo(new GVehicleReferenceDetails(this.data.getVehicle()), this.data.getVehicle().getReferenceId()), this.createLegalInfo()), this.dealId));
    }

    @Override
    @Nullable
    public Map<String, String> buildQueryParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_RATE_ONLY, String.valueOf(true));
        return params;
    }

    private void mergeDriver(List<GContact> contacts, @NonNull Driver driver) {
        boolean added = false;
        for (GContact contact : contacts) {
            if (!this.checkSamePerson(contact, driver)) continue;
            ArrayList<GPassport> passports = new ArrayList<GPassport>();
            boolean licenseAdded = false;
            block9: for (GPassport passport : contact.Passports) {
                switch (passport.DocumentType) {
                    case "\u041f\u0430\u0441\u043f\u043e\u0440\u0442 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0438\u043d\u0430 \u0420\u0424": {
                        passports.add(passport);
                        continue block9;
                    }
                    case "\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B": {
                        passports.add(new GPassport("\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B", driver.getDriverLicense().getSeries(), driver.getDriverLicense().getNumber(), DateUtils.formatDate(driver.getDriverLicense().getIssueDate()), passport.DocumentId));
                        licenseAdded = true;
                    }
                }
            }
            if (!licenseAdded) {
                passports.add(new GPassport("\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B", driver.getDriverLicense().getSeries(), driver.getDriverLicense().getNumber(), DateUtils.formatDate(driver.getDriverLicense().getIssueDate()), driver.getDriverLicense().getId()));
            }
            contact.setDateOfFIDL(DateUtils.formatDate(driver.getDriverLicense().getFirstYearIssueDate())).setPassports(passports.toArray(new GPassport[passports.size()]));
            driver.setSubjectNumber(contact.SubjectNumber);
            added = true;
            break;
        }
        if (!added) {
            contacts.add(this.createContact(driver));
        }
    }

    @NonNull
    private GContact createContact(@NonNull Insurer insurer, @NonNull InsuranceConditions conditions) {
        return this.createContact(insurer).setEmail(conditions.getEmail());
    }

    @NonNull
    private GContact createContact(@NonNull Contact contact) {
        ArrayList<GPhone> phones = new ArrayList<GPhone>();
        if (contact.getPhone() != null) {
            phones.add(new GPhone(contact.getPhone().getValue(), contact.getPhone().getType()));
        }
        return this.createContact((Subject)contact).setPhones(phones.toArray(new GPhone[phones.size()])).setAddresses(this.createAddresses(contact)).setPassports(this.createPassports(contact));
    }

    @NonNull
    private GContact createContact(@NonNull Subject subject) {
        return new GContact().setPublicId(subject.getId()).setSubjectNumber(subject.getSubjectNumber()).setFirstName(subject.getFirstName()).setLastName(subject.getLastName()).setMiddleName(subject.getMiddleName()).setGender(subject.getGender().toString()).setBirthDate(DateUtils.formatDate(subject.getBirthDate()));
    }

    @NonNull
    private GContact createContact(@NonNull Driver driver) {
        return this.createContact((Subject)driver).setPhones(new GPhone[0]).setAddresses(new GAddress[0]).setPassports(new GPassport[]{new GPassport("\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B", driver.getDriverLicense().getSeries(), driver.getDriverLicense().getNumber(), DateUtils.formatDate(driver.getDriverLicense().getIssueDate()), driver.getDriverLicense().getId())}).setDateOfFIDL(DateUtils.formatDate(driver.getDriverLicense().getFirstYearIssueDate()));
    }

    private boolean checkSamePerson(GContact contact, Subject subject) {
        return StringUtilsKt.equals(contact.BirthDate, DateUtils.formatDate(subject.getBirthDate())) && StringUtilsKt.equals(contact.FirstName, subject.getFirstName()) && StringUtilsKt.equals(contact.LastName, subject.getLastName()) && StringUtilsKt.equals(contact.MiddleName, subject.getMiddleName());
    }

    private boolean checkSamePerson(Contact contact, Insurer insurer) {
        if (!StringUtilsKt.equals(DateUtils.formatDate(contact.getBirthDate()), DateUtils.formatDate(insurer.getBirthDate()))) {
            return false;
        }
        if (!StringUtilsKt.equals(contact.getFirstName(), insurer.getFirstName())) {
            return false;
        }
        if (!StringUtilsKt.equals(contact.getLastName(), insurer.getLastName())) {
            return false;
        }
        if (!StringUtilsKt.equals(contact.getMiddleName(), insurer.getMiddleName())) {
            return false;
        }
        if (!contact.getHomeAddress().equals(insurer.getHomeAddress())) {
            return false;
        }
        if (!contact.getRegisteredAddress().equals(insurer.getRegisteredAddress())) {
            return false;
        }
        return contact.getPassport().equals(insurer.getPassport());
    }

    @NonNull
    private GDriver createDriver(Driver driver) {
        return new GDriver(driver.getSubjectNumber(), DateUtils.formatDate(driver.getDriverLicense().getFirstYearIssueDate()));
    }

    private GPassport[] createPassports(@NonNull Contact contact) {
        ArrayList<GPassport> passports = new ArrayList<GPassport>();
        passports.add(new GContactPassport(contact.getPassport().getSeries(), contact.getPassport().getNumber(), DateUtils.formatDate(contact.getPassport().getDateIssue()), contact.getPassport().getId()));
        if (contact.getDriverLicense() != null) {
            passports.add(new GPassport("\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B", ((PartialDriverLicense)contact.getDriverLicense()).getSeries(), ((PartialDriverLicense)contact.getDriverLicense()).getNumber(), DateUtils.formatDate(((PartialDriverLicense)contact.getDriverLicense()).getIssueDate()), ((PartialDriverLicense)contact.getDriverLicense()).getId()));
        }
        return passports.toArray(new GPassport[passports.size()]);
    }

    @NonNull
    protected GVehicleLegalInfo createLegalInfo() {
        GVehicleLegalInfo vehicleLegalInfo = new GVehicleLegalInfo();
        vehicleLegalInfo.setYear(this.data.getVehicle().getYear()).setVIN(this.vehicleDocument.getVin());
        if (this.conditions.getExpirationDC() != null) {
            vehicleLegalInfo.TechInspectionInfo = new GTechInspectionInfo(this.conditions.getNumberDC(), DateUtils.formatDate(this.conditions.getExpirationDC()));
        }
        return vehicleLegalInfo.setVehicleDocument(new GVehicleDocument[]{new GVehicleDocument(this.vehicleDocument.getTypeDocument().toString(), this.vehicleDocument.getSeries(), this.vehicleDocument.getNumber(), DateUtils.formatDate(this.vehicleDocument.getIssueDate()))}).setVehicleCost((int)this.data.getVehicle().getVehicleAvgPrice()).setVehicleUseRegion(CommonUtils.getRegionFromKladr(this.owner.getHomeAddress().getRegionKladr())).setRegistrationNumber(this.vehicleDocument.getLicensePlate());
    }

    @NonNull
    protected GAddress[] createAddresses(@NonNull Contact contact) {
        GAddress[] addresses = new GAddress[2];
        GAddress regAddress = new GAddress(contact.getRegisteredAddress().getRegionKladr(), contact.getRegisteredAddress().getCity(), contact.getRegisteredAddress().getCityKladr(), contact.getRegisteredAddress().getPopulatedCenter(), contact.getRegisteredAddress().getPopulatedCenterKladr(), "\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438", contact.getRegisteredAddress().getStreet(), contact.getRegisteredAddress().getStreetKladr(), contact.getRegisteredAddress().getFormattedBuilding(), contact.getRegisteredAddress().getFlat());
        regAddress.AddressId = contact.getRegisteredAddress().getId();
        GAddress homeAddress = new GAddress(contact.getHomeAddress().getRegionKladr(), contact.getHomeAddress().getCity(), contact.getHomeAddress().getCityKladr(), contact.getHomeAddress().getPopulatedCenter(), contact.getHomeAddress().getPopulatedCenterKladr(), "\u0410\u0434\u0440\u0435\u0441 \u0444\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0436\u0438\u0432\u0430\u043d\u0438\u044f", contact.getHomeAddress().getStreet(), contact.getHomeAddress().getStreetKladr(), contact.getHomeAddress().getFormattedBuilding(), contact.getHomeAddress().getFlat());
        homeAddress.AddressId = contact.getHomeAddress().getId();
        addresses[0] = regAddress;
        addresses[1] = homeAddress;
        return addresses;
    }
}

