/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.model;

import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FileType {
    PDF("application/pdf"),
    JPG("image/jpeg"),
    JPEG("image/jpeg"),
    BMP("image/vnd.wap.wbmp"),
    PNG("image/png"),
    TIF("image/tiff"),
    GIF("image/gif");

    private final MediaType mediaType;

    private FileType(String mediaType) {
        this.mediaType = MediaType.parse((String)mediaType);
    }

    @NotNull
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Nullable
    public static FileType parse(@Nullable String sType) {
        for (FileType type : FileType.values()) {
            if (!type.mediaType.subtype().equals(sType)) continue;
            return type;
        }
        return null;
    }
}

