/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.scan;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class QuoteSet {
    public static final String PASSPORT = "Passport";
    public static final String DRIVING_LICENSE = "DrivingLicense";
    public static final String PTS = "PTS";
    public static final String STS = "STS";
    public static final String TECH_CARD = "TechCard";
    private final String PolicyId;
    private final String Phone;
    private final ScanDocument[] ScanDocuments;

    public QuoteSet(@NotNull String policyId, @NotNull String phone, @NotNull ScanDocument[] scanDocuments) {
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(policyId));
        this.PolicyId = policyId;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(phone));
        this.Phone = phone;
        Preconditions.checkNotNull(scanDocuments);
        this.ScanDocuments = scanDocuments;
    }

    @NotNull
    public String getPolicyId() {
        return this.PolicyId;
    }

    @NotNull
    public String getPhone() {
        return this.Phone;
    }

    @NotNull
    public ScanDocument[] getScanDocuments() {
        return this.ScanDocuments;
    }

    public static class ScanDocument {
        private final String DocumentType;
        private final String Number;
        private final long Id;
        private final String Extension;

        public ScanDocument(@NotNull String documentType, @Nullable String seriesNumber, long id, @NotNull String extension) {
            Preconditions.checkArgument(StringUtilsKt.isNotBlank(documentType));
            this.DocumentType = documentType;
            this.checkNumber(seriesNumber, documentType);
            this.Number = seriesNumber;
            Preconditions.checkArgument(StringUtilsKt.isNotBlank(extension));
            this.Extension = extension;
            this.Id = id;
        }

        private void checkNumber(String number, String documentType) {
            if (QuoteSet.DRIVING_LICENSE.equals(documentType) && StringUtilsKt.isEmpty(number) || !QuoteSet.DRIVING_LICENSE.equals(documentType) && number != null) {
                throw new IllegalArgumentException();
            }
        }

        public long getFileId() {
            return this.Id;
        }

        @NotNull
        public String getExtension() {
            return this.Extension;
        }
    }
}

