/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.scan;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.utils.Preconditions;

public class Scan
implements Serializable {
    public static final int SUBJECT_NUMBER_NONE = -1;
    private final String id;
    private final int subjectNumber;
    private final Type type;

    public Scan(int subjectNumber, @NotNull Type type) {
        this.subjectNumber = subjectNumber;
        Preconditions.checkNotNull(type);
        this.type = type;
        this.id = this.generateId(subjectNumber, type);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public int getSubjectNumber() {
        return this.subjectNumber;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "Scan{subjectNumber=" + this.subjectNumber + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scan scan = (Scan)o;
        return this.id.equals(scan.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    private String generateId(int subjectNumber, @NotNull Type type) {
        return String.format("%d_%s", new Object[]{subjectNumber, type});
    }

    public static enum Type {
        PASSPORT,
        DRIVER_LICENCE,
        DOCUMENTS_CAR,
        TECH_CARD;

    }
}

