/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Passport;
import ru.tinkoff.tisdk.subject.Phone;
import ru.tinkoff.tisdk.subject.Subject;

public class Contact
extends Subject<PartialDriverLicense, Contact> {
    private static final int FOURTEEN_AGE = 14;
    private static final int TWENTY_AGE = 20;
    private static final int FORTY_FIVE_AGE = 45;
    private final Passport passport;
    private final Address registeredAddress;
    private final Address homeAddress;
    private Phone phone;

    public static boolean validateFourteenAge(Date birthDate, Date issuePassport) {
        return Contact.checkAgePassport(14, birthDate, issuePassport);
    }

    public static boolean validateTwentyAge(Date birthDate, Date issuePassport) {
        return Contact.checkAgePassport(20, birthDate, issuePassport);
    }

    public static boolean validateFortyFiveAge(Date birthDate, Date issuePassport) {
        return Contact.checkAgePassport(45, birthDate, issuePassport);
    }

    private static boolean checkAgePassport(int checkAge, Date birthDate, Date issuePassport) {
        if (birthDate == null || issuePassport == null) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, -checkAge);
        boolean moreThanCheckAge = birthDate.compareTo(c.getTime()) < 0;
        c.setTime(birthDate);
        c.add(1, checkAge);
        return !moreThanCheckAge || issuePassport.compareTo(c.getTime()) >= 0;
    }

    public Contact(int subjectNumber, @NotNull String fio, @NotNull Date birthDate, @Nullable Subject.Gender gender, @NotNull Passport passport, @NotNull Address registeredAddress, @NotNull Address homeAddress) {
        super(subjectNumber, fio, birthDate, gender);
        this.checkPassport(passport);
        this.checkRegisterAddress(registeredAddress);
        this.checkHomeAddress(homeAddress);
        this.passport = passport;
        this.registeredAddress = registeredAddress;
        this.homeAddress = homeAddress;
        this.checkTwentyAge();
        this.checkFortyFiveAge();
    }

    @NotNull
    public Passport getPassport() {
        return this.passport;
    }

    @NotNull
    public Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    @NotNull
    public Address getHomeAddress() {
        return this.homeAddress;
    }

    public void setPhone(@NotNull Phone phone) {
        this.checkPhone(phone);
        this.phone = phone;
    }

    public Phone getPhone() {
        return this.phone;
    }

    private void checkPassport(Passport passport) {
        if (passport == null) {
            throw new Passport.PassportException();
        }
    }

    private void checkRegisterAddress(Address address) {
        if (address == null || address.getType() != Address.Type.REGISTER) {
            throw new Address.AddressException();
        }
    }

    private void checkHomeAddress(Address address) {
        if (address == null || address.getType() != Address.Type.HOME) {
            throw new Address.AddressException();
        }
    }

    private void checkTwentyAge() {
        if (!Contact.validateTwentyAge(this.getBirthDate(), this.passport.getDateIssue())) {
            throw new IllegalArgumentException();
        }
    }

    private void checkFortyFiveAge() {
        if (!Contact.validateFortyFiveAge(this.getBirthDate(), this.passport.getDateIssue())) {
            throw new IllegalArgumentException();
        }
    }

    private void checkPhone(Phone phone) {
        if (phone == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void copyIds(@NotNull Contact contact) {
        super.copyIds(contact);
        this.homeAddress.setId(contact.getHomeAddress().getId());
        this.registeredAddress.setId(contact.getRegisteredAddress().getId());
        this.passport.setId(contact.getPassport().getId());
        if (contact.getDriverLicense() != null) {
            this.setDriverLicense(contact.getDriverLicense());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Contact contact = (Contact)o;
        if (this.passport != null ? !this.passport.equals(contact.passport) : contact.passport != null) {
            return false;
        }
        if (this.registeredAddress != null ? !this.registeredAddress.equals(contact.registeredAddress) : contact.registeredAddress != null) {
            return false;
        }
        if (this.homeAddress != null ? !this.homeAddress.equals(contact.homeAddress) : contact.homeAddress != null) {
            return false;
        }
        return this.phone != null ? this.phone.equals(contact.phone) : contact.phone == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.passport != null ? this.passport.hashCode() : 0);
        result = 31 * result + (this.registeredAddress != null ? this.registeredAddress.hashCode() : 0);
        result = 31 * result + (this.homeAddress != null ? this.homeAddress.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        return result;
    }
}

