/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.FullDriverLicense;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.DateUtils;

public class Driver
extends Subject<FullDriverLicense, Driver> {
    private static final int CORRECT_DRIVER_AGE = 18;
    private static final int DRIVER_LICENSE_VALID_YEARS = 10;

    public static boolean validateDateIssueLicense(@Nullable Date dateIssueLicense, @Nullable Date birthDate) {
        Calendar c;
        if (dateIssueLicense == null) {
            return false;
        }
        boolean ageValid = true;
        if (birthDate != null) {
            c = Calendar.getInstance();
            c.setTime(birthDate);
            c.add(1, 18);
            ageValid = dateIssueLicense.compareTo(c.getTime()) >= 0;
        }
        c = Calendar.getInstance();
        c.setTime(dateIssueLicense);
        c.add(1, 10);
        Date now = new Date();
        boolean issueDateValid = dateIssueLicense.compareTo(now) <= 0 && c.getTime().compareTo(now) > 0;
        return ageValid && issueDateValid;
    }

    public static boolean validateFirstYearIssueLicense(@Nullable Date firstDateIssueLicense, @Nullable Date lastDateIssueLicense, @Nullable Date birthDate) {
        if (firstDateIssueLicense == null) {
            return false;
        }
        int firstIssueYear = DateUtils.getYear(firstDateIssueLicense);
        if (lastDateIssueLicense != null && firstIssueYear > DateUtils.getYear(lastDateIssueLicense)) {
            return false;
        }
        boolean ageValid = true;
        if (birthDate != null) {
            int minFirstIssueYear = DateUtils.getYear(birthDate) + 18;
            ageValid = firstIssueYear >= minFirstIssueYear;
        }
        return ageValid && firstDateIssueLicense.compareTo(new Date()) <= 0;
    }

    public Driver(int subjectNumber, @NotNull String fio, @NotNull Date birthDate, @Nullable Subject.Gender gender, @NotNull String seriesNumberLicense, @NotNull Date dateIssueLicense, @NotNull Date firstYearIssueLicense) {
        super(subjectNumber, fio, birthDate, gender);
        this.setDriverLicense(new FullDriverLicense(seriesNumberLicense, dateIssueLicense, firstYearIssueLicense));
    }

    @Override
    @NotNull
    public FullDriverLicense getDriverLicense() {
        FullDriverLicense driverLicense = (FullDriverLicense)super.getDriverLicense();
        if (driverLicense == null) {
            throw new IllegalStateException("Driver license is null");
        }
        return driverLicense;
    }

    @Override
    public void setDriverLicense(@NotNull FullDriverLicense driverLicense) {
        this.checkDateIssueLicense(driverLicense.getIssueDate(), this.getBirthDate());
        this.checkFirstYearIssueLicense(driverLicense.getFirstYearIssueDate(), driverLicense.getIssueDate(), this.getBirthDate());
        super.setDriverLicense(driverLicense);
    }

    private void checkDateIssueLicense(Date dateIssueLicense, Date birthDate) {
        if (!Driver.validateDateIssueLicense(dateIssueLicense, birthDate)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkFirstYearIssueLicense(Date firstDateIssueLicense, Date lastDateIssueLicense, Date birthDate) {
        if (!Driver.validateFirstYearIssueLicense(firstDateIssueLicense, lastDateIssueLicense, birthDate)) {
            throw new IllegalArgumentException();
        }
    }
}

