/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.Preconditions;

public class Drivers
implements Serializable {
    private static final String MULTI_DRIVE = "\u043c\u0443\u043b\u044c\u0442\u0438\u0434\u0440\u0430\u0439\u0432";
    private final boolean multiple;
    private final Driver[] drivers;

    public Drivers() {
        this.multiple = true;
        this.drivers = null;
    }

    public Drivers(@NotNull Driver[] drivers) {
        Preconditions.checkNotNull(drivers);
        if (drivers.length == 0) {
            throw new IllegalArgumentException();
        }
        this.drivers = drivers;
        this.multiple = false;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    @Nullable
    public Driver[] getDrivers() {
        return this.drivers;
    }

    @Nullable
    public Driver getDriver(int subjectNumber) {
        if (this.drivers != null) {
            for (Driver driver : this.drivers) {
                if (driver.getSubjectNumber() != subjectNumber) continue;
                return driver;
            }
        }
        return null;
    }

    @NotNull
    public String getLicense() {
        if (this.multiple) {
            return MULTI_DRIVE;
        }
        int minExperience = DateUtils.yearsBetween(this.drivers[0].getDriverLicense().getFirstYearIssueDate(), new Date());
        if (this.drivers.length > 1) {
            for (int i = 1; i < this.drivers.length; ++i) {
                Driver driver = this.drivers[i];
                int drivingExperienceYears = DateUtils.yearsBetween(driver.getDriverLicense().getFirstYearIssueDate(), new Date());
                minExperience = Math.min(drivingExperienceYears, minExperience);
            }
        }
        return String.valueOf(minExperience);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Drivers drivers1 = (Drivers)o;
        if (this.multiple != drivers1.multiple) {
            return false;
        }
        return Arrays.equals(this.drivers, drivers1.drivers);
    }

    public int hashCode() {
        int result = this.multiple ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.drivers);
        return result;
    }
}

