/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Passport;
import ru.tinkoff.tisdk.subject.Subject;

public class Insurer
extends Contact {
    private static final int EIGHTEEN = 18;

    public static boolean validateAgeMoreThenEighteen(Date birthDate) {
        if (birthDate == null) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, -18);
        return birthDate.compareTo(c.getTime()) < 0;
    }

    public Insurer(@NotNull String fio, @NotNull Date birthDate, @Nullable Subject.Gender gender, @NotNull Passport passport, @NotNull Address registeredAddress, @NotNull Address homeAddress) {
        super(1, fio, birthDate, gender, passport, registeredAddress, homeAddress);
        this.checkAgeMoreThenEighteen(birthDate);
    }

    private void checkAgeMoreThenEighteen(Date birthDate) {
        if (!Insurer.validateAgeMoreThenEighteen(birthDate)) {
            throw new IllegalArgumentException();
        }
    }
}

