/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class PartialDriverLicense
implements Serializable {
    private static final String LICENSE_REGEXP = "^\\d{2}[\u0410\u0412\u0415\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u04250-9]{2}\\d{6}$";
    private static final int SERIES_LENGTH = 4;
    private String id;
    private final String seriesNumber;
    private final Date issueDate;

    public static boolean validateSeriesNumber(@Nullable String seriesNumberLicense) {
        if (StringUtilsKt.isEmpty(seriesNumberLicense)) {
            return false;
        }
        Matcher matcher = Pattern.compile(LICENSE_REGEXP).matcher(seriesNumberLicense);
        return matcher.matches();
    }

    public PartialDriverLicense(@NotNull String seriesNumber, @NotNull Date issueDate) {
        this.seriesNumber = this.checkSeriesNumber(seriesNumber);
        this.issueDate = Preconditions.checkNotNull(issueDate);
    }

    public PartialDriverLicense(@NotNull String series, @NotNull String number, @NotNull Date issueDate) {
        this(series + number, issueDate);
    }

    private String checkSeriesNumber(String seriesNumber) {
        if (!PartialDriverLicense.validateSeriesNumber(seriesNumber)) {
            throw new IllegalArgumentException();
        }
        return seriesNumber;
    }

    @NotNull
    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    @NotNull
    public Date getIssueDate() {
        return this.issueDate;
    }

    @NotNull
    public String getSeries() {
        return this.seriesNumber.substring(0, 4);
    }

    @NotNull
    public String getNumber() {
        return this.seriesNumber.substring(4);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialDriverLicense that = (PartialDriverLicense)o;
        if (this.seriesNumber != null ? !this.seriesNumber.equals(that.seriesNumber) : that.seriesNumber != null) {
            return false;
        }
        return this.issueDate != null ? this.issueDate.equals(that.issueDate) : that.issueDate == null;
    }

    public int hashCode() {
        int result = this.seriesNumber != null ? this.seriesNumber.hashCode() : 0;
        result = 31 * result + (this.issueDate != null ? this.issueDate.hashCode() : 0);
        return result;
    }
}

