/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class Passport
implements Serializable {
    private static final String SERIES_NUMBER_PASSPORT_REGEX = "^(\\d{4})(\\d{6})$";
    private static final int YEAR_CHANGE_PASSPORT = 1997;
    private static final int MONTH_CHANGE_PASSPORT = 9;
    private static final int DAY_CHANGE_PASSPORT = 1;
    private String id;
    private final Date dateIssue;
    private final String number;
    private final String series;

    public static boolean validateDateIssue(Date dateIssue) {
        if (dateIssue == null) {
            return false;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1997, 9, 1, 0, 0, 0);
        calendar.set(14, 0);
        if (dateIssue.compareTo(calendar.getTime()) < 0) {
            return false;
        }
        calendar.setTime(new Date());
        return dateIssue.compareTo(calendar.getTime()) <= 0;
    }

    public static boolean validateSeriesNumber(String seriesAndNumber) {
        if (StringUtilsKt.isEmpty(seriesAndNumber)) {
            return false;
        }
        Matcher matcher = Pattern.compile(SERIES_NUMBER_PASSPORT_REGEX).matcher(seriesAndNumber);
        return matcher.matches();
    }

    public Passport(@NotNull Date dateIssue, @NotNull String seriesAndNumber) {
        if (!Passport.validateDateIssue(dateIssue)) {
            throw new DateIssuePassportException();
        }
        this.dateIssue = dateIssue;
        if (!Passport.validateSeriesNumber(seriesAndNumber)) {
            throw new SeriesNumberPassportException();
        }
        this.series = seriesAndNumber.substring(0, 4);
        this.number = seriesAndNumber.substring(4);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @NotNull
    public Date getDateIssue() {
        return this.dateIssue;
    }

    @NotNull
    public String getNumber() {
        return this.number;
    }

    @NotNull
    public String getSeries() {
        return this.series;
    }

    @NotNull
    public String getSeriesNumber() {
        return this.series + this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Passport passport = (Passport)o;
        if (this.dateIssue != null ? !this.dateIssue.equals(passport.dateIssue) : passport.dateIssue != null) {
            return false;
        }
        if (this.number != null ? !this.number.equals(passport.number) : passport.number != null) {
            return false;
        }
        return !(this.series != null ? !this.series.equals(passport.series) : passport.series != null);
    }

    public int hashCode() {
        int result = this.dateIssue != null ? this.dateIssue.hashCode() : 0;
        result = 17 * result + (this.number != null ? this.number.hashCode() : 0);
        result = 17 * result + (this.series != null ? this.series.hashCode() : 0);
        return result;
    }

    public static class SeriesNumberPassportException
    extends PassportException {
    }

    public static class DateIssuePassportException
    extends PassportException {
    }

    public static class PassportException
    extends IllegalArgumentException {
    }
}

