/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Phone
implements Serializable {
    public static final String COUNTRY_CODE_RUS_INTERNATIONAL = "7";
    public static final String COUNTRY_CODE_RUS_INTERNAL = "8";
    private static final String PHONE_NUMBER_REGEX = "^7[345689]\\d{9}$";
    private static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^7[345689]\\d{9}$");
    private final String value;
    private final String type = "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439";

    public static boolean validatePhone(@Nullable String phone) {
        return phone != null && PHONE_NUMBER_PATTERN.matcher(phone).matches();
    }

    public Phone(@NotNull String value) {
        this.checkValue(value);
        this.value = value;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @NotNull
    public String getType() {
        return "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Phone phone = (Phone)o;
        if (this.value != null ? !this.value.equals(phone.value) : phone.value != null) {
            return false;
        }
        return !("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439" != null ? !"\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439".equals(phone.type) : phone.type != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 17 * result + ("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439" != null ? "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439".hashCode() : 0);
        return result;
    }

    private void checkValue(String value) {
        if (!Phone.validatePhone(value)) {
            throw new PhoneException();
        }
    }

    public class PhoneException
    extends IllegalArgumentException {
    }
}

