/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class Subject<DriverLicenseType extends PartialDriverLicense, CopyIdsType extends Subject>
implements Serializable {
    public static final int SUBJECT_NUMBER_INSURER = 1;
    public static final int SUBJECT_NUMBER_OWNER = 2;
    public static final int SUBJECT_NUMBER_DRIVER1 = 3;
    public static final int SUBJECT_NUMBER_DRIVER2 = 4;
    public static final int SUBJECT_NUMBER_DRIVER3 = 5;
    public static final int SUBJECT_NUMBER_DRIVER4 = 6;
    public static final int SUBJECT_NUMBER_DRIVER5 = 7;
    private static final int EIGHTEEN_YEARS = 18;
    private static final int MIN_BIRTHDATE_YEAR = 1920;
    private static final int MIN_BIRTHDATE_MONTH = 0;
    private static final int MIN_BIRTHDATE_DAY = 1;
    private static final String LAST_NAME_SEPARATOR = "-";
    private static final String FIO_REGEXP = "^([\u0410-\u042f\u0401][\u0430-\u044f\u0451]+(?:-[\u0410-\u042f\u0401][\u0430-\u044f\u0451]+)?) ([\u0410-\u042f\u0401][\u0430-\u044f\u0451]+) ([\u0410-\u042f\u0401][\u0430-\u044f\u0451]+)$";
    private int subjectNumber;
    private String id;
    private final String lastName;
    private final String firstName;
    private final String middleName;
    private final Date birthDate;
    private final Gender gender;
    private DriverLicenseType driverLicense;

    public static boolean validateFio(String fio) {
        if (StringUtilsKt.isEmpty(fio)) {
            return false;
        }
        Matcher matcher = Pattern.compile(FIO_REGEXP).matcher(fio);
        return matcher.matches();
    }

    public static boolean validateBirthDate(Date birthDate) {
        if (birthDate == null) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.add(1, -18);
        if (birthDate.compareTo(c.getTime()) > 0) {
            return false;
        }
        c.set(1920, 0, 1, 0, 0, 0);
        c.set(14, 0);
        return birthDate.compareTo(c.getTime()) >= 0;
    }

    public static String[] splitFio(@NotNull String fio) {
        Matcher matcher = Pattern.compile(FIO_REGEXP).matcher(fio);
        matcher.matches();
        String lastName = matcher.group(1);
        if (lastName.contains(LAST_NAME_SEPARATOR)) {
            String[] partsLastName = lastName.split(LAST_NAME_SEPARATOR);
            String onePart = Subject.capitalizeName(partsLastName[0]);
            String twoPart = Subject.capitalizeName(partsLastName[1]);
            lastName = onePart + LAST_NAME_SEPARATOR + twoPart;
        }
        String firstName = Subject.capitalizeName(matcher.group(2));
        String middleName = Subject.capitalizeName(matcher.group(3));
        return new String[]{lastName, firstName, middleName};
    }

    private static String capitalizeName(@NotNull String name) {
        if (name.length() == 0) {
            return name;
        }
        return String.valueOf(Character.toTitleCase(name.charAt(0))) + name.substring(1).toLowerCase();
    }

    public Subject(@NotNull String fio, @NotNull Date birthDate, @Nullable Gender gender) {
        this(0, fio, birthDate, gender);
    }

    public Subject(int subjectNumber, @NotNull String fio, @NotNull Date birthDate, @Nullable Gender gender) {
        this.checkName(fio);
        String[] names = Subject.splitFio(fio);
        this.lastName = names[0];
        this.firstName = names[1];
        this.middleName = names[2];
        this.checkBirthDate(birthDate);
        this.birthDate = birthDate;
        if (gender == null) {
            gender = Gender.extractGender(this.middleName);
        }
        this.checkGender(gender);
        this.gender = gender;
        this.subjectNumber = subjectNumber;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSubjectNumber(int subjectNumber) {
        this.subjectNumber = subjectNumber;
    }

    public void setDriverLicense(@NotNull DriverLicenseType driverLicense) {
        this.driverLicense = (PartialDriverLicense)Preconditions.checkNotNull(driverLicense);
    }

    @Nullable
    public DriverLicenseType getDriverLicense() {
        return this.driverLicense;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public int getSubjectNumber() {
        return this.subjectNumber;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public Gender getGender() {
        return this.gender;
    }

    private void checkGender(Gender gender) {
        if (gender == null) {
            throw new IllegalArgumentException();
        }
    }

    private void checkName(String name) {
        if (!Subject.validateFio(name)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkBirthDate(Date birthDate) {
        if (!Subject.validateBirthDate(birthDate)) {
            throw new IllegalArgumentException();
        }
    }

    public void copyIds(@NotNull CopyIdsType subject) {
        this.id = ((Subject)subject).getId();
        if (((Subject)subject).getDriverLicense() != null && this.driverLicense != null) {
            ((PartialDriverLicense)this.driverLicense).setId(((PartialDriverLicense)((Subject)subject).getDriverLicense()).getId());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subject subject = (Subject)o;
        if (this.lastName != null ? !this.lastName.equals(subject.lastName) : subject.lastName != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(subject.firstName) : subject.firstName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(subject.middleName) : subject.middleName != null) {
            return false;
        }
        if (this.birthDate != null ? !this.birthDate.equals(subject.birthDate) : subject.birthDate != null) {
            return false;
        }
        if (this.gender != subject.gender) {
            return false;
        }
        return this.driverLicense != null ? ((PartialDriverLicense)this.driverLicense).equals(subject.driverLicense) : subject.driverLicense == null;
    }

    public int hashCode() {
        int result = this.lastName != null ? this.lastName.hashCode() : 0;
        result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 31 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.driverLicense != null ? ((PartialDriverLicense)this.driverLicense).hashCode() : 0);
        return result;
    }

    public static enum Gender {
        MALE,
        FEMALE;

        private static final String GENDER_MALE_RU = "\u041c\u0443\u0436\u0441\u043a\u043e\u0439";
        private static final String GENDER_MALE_EN = "Male";
        private static final String GENDER_FEMALE_RU = "\u0416\u0435\u043d\u0441\u043a\u0438\u0439";
        private static final String GENDER_FEMALE_EN = "Female";
        private static final String MIDDLE_NAME_MALE_ENDING = "\u0432\u0438\u0447";

        @Nullable
        public static Gender fromValue(@NotNull String gender) {
            if (GENDER_MALE_RU.equalsIgnoreCase(gender) || GENDER_MALE_EN.equalsIgnoreCase(gender)) {
                return MALE;
            }
            if (GENDER_FEMALE_RU.equalsIgnoreCase(gender) || GENDER_FEMALE_EN.equalsIgnoreCase(gender)) {
                return FEMALE;
            }
            return null;
        }

        @NotNull
        public static Gender extractGender(@NotNull String middleName) {
            if (middleName.endsWith(MIDDLE_NAME_MALE_ENDING)) {
                return MALE;
            }
            return FEMALE;
        }

        public String toString() {
            switch (this) {
                case MALE: {
                    return GENDER_MALE_RU;
                }
                case FEMALE: {
                    return GENDER_FEMALE_RU;
                }
            }
            return super.toString();
        }
    }
}

