/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class CommonUtils {
    private static final Pattern FIRST_LETTER_PATTERN = Pattern.compile(" [\u0430-\u044f\u0451]");
    private static final Pattern FIRST_LETTER_PATTERN_DOUBLE_LAST_NAME = Pattern.compile("-[\u0430-\u044f\u0451]");

    @NotNull
    public static String getRegionFromKladr(@NotNull String kladr) {
        return kladr.substring(0, 2);
    }

    @NotNull
    public static String formatName(@NotNull String unformattedName) {
        return unformattedName.substring(0, 1).toUpperCase() + unformattedName.substring(1).toLowerCase();
    }

    @Nullable
    public static String replaceSpace(String str) {
        return !StringUtilsKt.isEmpty(str) ? str.replace(" ", "") : null;
    }

    public static void putNotEmptyValue(@NotNull Map<String, String> map, @NotNull String key, @NotNull String value) {
        if (!StringUtilsKt.isEmpty(value)) {
            map.put(key, value);
        }
    }

    @NotNull
    public static String getFullFio(@NotNull Subject subject) {
        return CommonUtils.getFullFio(subject.getLastName(), subject.getFirstName(), subject.getMiddleName());
    }

    @NotNull
    public static String getFullFio(@NotNull String lastName, @NotNull String firstName, @NotNull String middleName) {
        return String.format("%s %s %s", lastName, firstName, middleName);
    }

    @NotNull
    public static String getShortFio(@NotNull Subject subject) {
        return String.format("%s %s. %s.", subject.getLastName(), subject.getFirstName().substring(0, 1), subject.getMiddleName().substring(0, 1));
    }

    @NotNull
    public static String formatFioUpperCase(@NotNull String fio) {
        if (fio.isEmpty()) {
            return fio;
        }
        fio = fio.toLowerCase();
        fio = fio.substring(0, 1).toUpperCase() + fio.substring(1);
        fio = CommonUtils.partToUpperCase(fio, FIRST_LETTER_PATTERN);
        return CommonUtils.partToUpperCase(fio, FIRST_LETTER_PATTERN_DOUBLE_LAST_NAME);
    }

    @NotNull
    private static String partToUpperCase(@NotNull String src, @NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher(src);
        if (matcher.find()) {
            String left = src.substring(0, matcher.start());
            String match = src.substring(matcher.start(), matcher.end());
            String right = src.substring(matcher.end());
            src = left + match.toUpperCase() + right;
            return CommonUtils.partToUpperCase(src, pattern);
        }
        return src;
    }
}

