/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.vehicle;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class Vehicle
implements Serializable {
    private static final int MIN_YEAR = 1900;
    private final String vehicleType = "\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438";
    private final int vehicleTypeId = 2;
    private String referenceId;
    private final String makeId;
    private final String makeName;
    private final String modelId;
    private final String modelName;
    private String rateGroupId;
    private double vehicleAvgPrice;
    private String rsaCode;
    private final String engineId;
    private final String engineName;
    private final String caseAndDoorsId;
    private final String caseAndDoorsName;
    private final String kppId;
    private final int year;

    public Vehicle(@NotNull String makeId, @NotNull String makeName, @NotNull String modelId, @NotNull String modelName, @NotNull String engineId, @NotNull String engineName, @NotNull String caseAndDoorsId, @NotNull String caseAndDoorsName, @NotNull String kppId, int year) {
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(makeId));
        this.makeId = makeId;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(makeName));
        this.makeName = makeName;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(modelId));
        this.modelId = modelId;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(modelName));
        this.modelName = modelName;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(engineId));
        this.engineId = engineId;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(engineName));
        this.engineName = engineName;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(caseAndDoorsId));
        this.caseAndDoorsId = caseAndDoorsId;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(caseAndDoorsName));
        this.caseAndDoorsName = caseAndDoorsName;
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(kppId));
        this.kppId = kppId;
        this.checkYear(year);
        this.year = year;
    }

    public void setDetails(@NotNull VehicleDetails details) {
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(details.getVehicleId()));
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(details.getGroupId()));
        this.referenceId = details.getVehicleId();
        this.rateGroupId = details.getGroupId();
        this.vehicleAvgPrice = this.checkPrice(details.getPrice());
        this.rsaCode = details.getRsaCode();
    }

    public boolean isDetailsInitialized() {
        return this.referenceId != null && this.rateGroupId != null;
    }

    @NotNull
    public String getReferenceId() {
        if (this.referenceId == null) {
            throw new IllegalStateException("Vehicle reference id not initialized");
        }
        return this.referenceId;
    }

    @NotNull
    public String getVehicleType() {
        return "\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438";
    }

    public int getVehicleTypeId() {
        return 2;
    }

    @NotNull
    public String getMakeId() {
        return this.makeId;
    }

    @NotNull
    public String getMakeName() {
        return this.makeName;
    }

    @NotNull
    public String getModelId() {
        return this.modelId;
    }

    @NotNull
    public String getModelName() {
        return this.modelName;
    }

    @NotNull
    public String getRateGroupId() {
        if (this.rateGroupId == null) {
            throw new IllegalStateException("Vehicle rate group id not initialized");
        }
        return this.rateGroupId;
    }

    public double getVehicleAvgPrice() {
        return this.vehicleAvgPrice;
    }

    @Nullable
    public String getRsaCode() {
        return this.rsaCode;
    }

    @NotNull
    public String getEngineId() {
        return this.engineId;
    }

    @NotNull
    public String getEngineName() {
        return this.engineName;
    }

    @NotNull
    public String getCaseAndDoorsId() {
        return this.caseAndDoorsId;
    }

    public String getCaseAndDoorsName() {
        return this.caseAndDoorsName;
    }

    @NotNull
    public String getKppId() {
        return this.kppId;
    }

    public int getYear() {
        return this.year;
    }

    private double checkPrice(double price) {
        if (price < 0.0) {
            throw new IllegalArgumentException();
        }
        return price;
    }

    private void checkYear(int year) {
        if (year <= 1900) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equalsExceptDetails(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vehicle vehicle = (Vehicle)o;
        if (2 != vehicle.vehicleTypeId) {
            return false;
        }
        if (Double.compare(vehicle.vehicleAvgPrice, this.vehicleAvgPrice) != 0) {
            return false;
        }
        if (this.year != vehicle.year) {
            return false;
        }
        if (("\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438" != null ? !"\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438".equals(vehicle.vehicleType) : vehicle.vehicleType != null) && (this.makeId != null ? !this.makeId.equals(vehicle.makeId) : vehicle.makeId != null)) {
            return false;
        }
        if (this.makeName != null ? !this.makeName.equals(vehicle.makeName) : vehicle.makeName != null) {
            return false;
        }
        if (this.modelId != null ? !this.modelId.equals(vehicle.modelId) : vehicle.modelId != null) {
            return false;
        }
        if (this.modelName != null ? !this.modelName.equals(vehicle.modelName) : vehicle.modelName != null) {
            return false;
        }
        if (this.rateGroupId != null ? !this.rateGroupId.equals(vehicle.rateGroupId) : vehicle.rateGroupId != null) {
            return false;
        }
        if (this.engineId != null ? !this.engineId.equals(vehicle.engineId) : vehicle.engineId != null) {
            return false;
        }
        if (this.engineName != null ? !this.engineName.equals(vehicle.engineName) : vehicle.engineName != null) {
            return false;
        }
        if (this.caseAndDoorsId != null ? !this.caseAndDoorsId.equals(vehicle.caseAndDoorsId) : vehicle.caseAndDoorsId != null) {
            return false;
        }
        if (this.caseAndDoorsName != null ? !this.caseAndDoorsName.equals(vehicle.caseAndDoorsName) : vehicle.caseAndDoorsName != null) {
            return false;
        }
        return this.kppId != null ? this.kppId.equals(vehicle.kppId) : vehicle.kppId == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vehicle vehicle = (Vehicle)o;
        if (2 != vehicle.vehicleTypeId) {
            return false;
        }
        if (Double.compare(vehicle.vehicleAvgPrice, this.vehicleAvgPrice) != 0) {
            return false;
        }
        if (this.year != vehicle.year) {
            return false;
        }
        if ("\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438" != null ? !"\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438".equals(vehicle.vehicleType) : vehicle.vehicleType != null) {
            return false;
        }
        if (this.referenceId != null ? !this.referenceId.equals(vehicle.referenceId) : vehicle.referenceId != null) {
            return false;
        }
        if (this.makeId != null ? !this.makeId.equals(vehicle.makeId) : vehicle.makeId != null) {
            return false;
        }
        if (this.makeName != null ? !this.makeName.equals(vehicle.makeName) : vehicle.makeName != null) {
            return false;
        }
        if (this.modelId != null ? !this.modelId.equals(vehicle.modelId) : vehicle.modelId != null) {
            return false;
        }
        if (this.modelName != null ? !this.modelName.equals(vehicle.modelName) : vehicle.modelName != null) {
            return false;
        }
        if (this.rateGroupId != null ? !this.rateGroupId.equals(vehicle.rateGroupId) : vehicle.rateGroupId != null) {
            return false;
        }
        if (this.engineId != null ? !this.engineId.equals(vehicle.engineId) : vehicle.engineId != null) {
            return false;
        }
        if (this.engineName != null ? !this.engineName.equals(vehicle.engineName) : vehicle.engineName != null) {
            return false;
        }
        if (this.caseAndDoorsId != null ? !this.caseAndDoorsId.equals(vehicle.caseAndDoorsId) : vehicle.caseAndDoorsId != null) {
            return false;
        }
        if (this.caseAndDoorsName != null ? !this.caseAndDoorsName.equals(vehicle.caseAndDoorsName) : vehicle.caseAndDoorsName != null) {
            return false;
        }
        return this.kppId != null ? this.kppId.equals(vehicle.kppId) : vehicle.kppId == null;
    }

    public int hashCode() {
        int result = "\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438" != null ? "\u041b\u0435\u0433\u043a\u043e\u0432\u044b\u0435 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0438".hashCode() : 0;
        result = 31 * result + 2;
        result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
        result = 31 * result + (this.makeId != null ? this.makeId.hashCode() : 0);
        result = 31 * result + (this.makeName != null ? this.makeName.hashCode() : 0);
        result = 31 * result + (this.modelId != null ? this.modelId.hashCode() : 0);
        result = 31 * result + (this.modelName != null ? this.modelName.hashCode() : 0);
        result = 31 * result + (this.rateGroupId != null ? this.rateGroupId.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.vehicleAvgPrice);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.engineId != null ? this.engineId.hashCode() : 0);
        result = 31 * result + (this.engineName != null ? this.engineName.hashCode() : 0);
        result = 31 * result + (this.caseAndDoorsId != null ? this.caseAndDoorsId.hashCode() : 0);
        result = 31 * result + (this.caseAndDoorsName != null ? this.caseAndDoorsName.hashCode() : 0);
        result = 31 * result + (this.kppId != null ? this.kppId.hashCode() : 0);
        result = 31 * result + this.year;
        return result;
    }
}

