/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.vehicle;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class VehicleDocument
implements Serializable {
    private static final String REG_EXP_LICENSE_PLATE = "^[\u0410\u0412\u0415\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u0425]\\d{3}[\u0410\u0412\u0415\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u0425]{2}\\d{2,3}$";
    private static final String REG_EXP_VIN = "^[0123456789ABCDEFGHJKLMNPRSTUVWXYZ]{17}$";
    private static final String REG_EXP_SERIES_AND_NUMBER = "^\\d{2}[\u0410-\u042f0-9]{2}\\d{6}$";
    private static final int SERIES_LEN = 4;
    private static final int NUMBER_LEN = 6;
    private static final String TYPE_STS = "31";
    private static final String TYPE_PTS = "30";
    private final String licensePlate;
    private final String vin;
    private final TypeDocument typeDocument;
    private final String seriesNumber;
    private final Date issueDate;

    public static boolean validateLicensePlate(@Nullable String licensePlate, @Nullable TypeDocument typeDocument) {
        if (typeDocument == TypeDocument.PTS && StringUtilsKt.isEmpty(licensePlate)) {
            return true;
        }
        if (StringUtilsKt.isEmpty(licensePlate)) {
            return false;
        }
        Matcher matcher = Pattern.compile(REG_EXP_LICENSE_PLATE).matcher(licensePlate);
        return matcher.matches();
    }

    public static boolean validateVin(String vin) {
        if (StringUtilsKt.isEmpty(vin)) {
            return false;
        }
        Matcher matcher = Pattern.compile(REG_EXP_VIN).matcher(vin);
        return matcher.matches();
    }

    public static boolean validateTypeDocument(TypeDocument typeDocument) {
        return typeDocument != null;
    }

    public static boolean validateSeriesNumber(String seriesNumber) {
        if (StringUtilsKt.isEmpty(seriesNumber)) {
            return false;
        }
        Matcher matcher = Pattern.compile(REG_EXP_SERIES_AND_NUMBER).matcher(seriesNumber);
        return matcher.matches();
    }

    public static boolean validateIssue(Date issueDate, int vehicleYear) {
        if (issueDate == null) {
            return false;
        }
        return issueDate.compareTo(new Date()) <= 0 && DateUtils.getYear(issueDate) >= vehicleYear;
    }

    public VehicleDocument(@Nullable String licensePlate, @NotNull String vin, @NotNull TypeDocument typeDocument, @NotNull String seriesNumber, @NotNull Date issueDate) {
        this.checkVin(vin);
        this.vin = vin;
        this.checkTypeDocument(typeDocument);
        this.typeDocument = typeDocument;
        this.checkLicensePlate(licensePlate, typeDocument);
        this.licensePlate = licensePlate;
        this.checkSeriesNumber(seriesNumber);
        this.seriesNumber = seriesNumber;
        this.checkIssueDate(issueDate);
        this.issueDate = issueDate;
    }

    @NotNull
    public String getLicensePlate() {
        return this.licensePlate;
    }

    @NotNull
    public String getVin() {
        return this.vin;
    }

    @NotNull
    public TypeDocument getTypeDocument() {
        return this.typeDocument;
    }

    @NotNull
    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    @NotNull
    public String getSeries() {
        return this.seriesNumber.substring(0, 4);
    }

    @NotNull
    public String getNumber() {
        return this.seriesNumber.substring(this.seriesNumber.length() - 6);
    }

    @NotNull
    public Date getIssueDate() {
        return this.issueDate;
    }

    private void checkLicensePlate(String licensePlate, TypeDocument typeDocument) {
        if (!VehicleDocument.validateLicensePlate(licensePlate, typeDocument)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkVin(String vin) {
        if (!VehicleDocument.validateVin(vin)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkTypeDocument(TypeDocument typeDocument) {
        if (!VehicleDocument.validateTypeDocument(typeDocument)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkSeriesNumber(String seriesNumber) {
        if (!VehicleDocument.validateSeriesNumber(seriesNumber)) {
            throw new IllegalArgumentException();
        }
    }

    private void checkIssueDate(Date issue) {
        if (!VehicleDocument.validateIssue(issue, 0)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleDocument that = (VehicleDocument)o;
        if (this.licensePlate != null ? !this.licensePlate.equals(that.licensePlate) : that.licensePlate != null) {
            return false;
        }
        if (!this.vin.equals(that.vin)) {
            return false;
        }
        if (this.typeDocument != that.typeDocument) {
            return false;
        }
        if (!this.seriesNumber.equals(that.seriesNumber)) {
            return false;
        }
        return this.issueDate.equals(that.issueDate);
    }

    public int hashCode() {
        int result = this.licensePlate != null ? this.licensePlate.hashCode() : 0;
        result = 31 * result + this.vin.hashCode();
        result = 31 * result + this.typeDocument.hashCode();
        result = 31 * result + this.seriesNumber.hashCode();
        result = 31 * result + this.issueDate.hashCode();
        return result;
    }

    public static enum TypeDocument {
        STS,
        PTS;


        public String toString() {
            switch (this) {
                case PTS: {
                    return VehicleDocument.TYPE_PTS;
                }
                case STS: {
                    return VehicleDocument.TYPE_STS;
                }
            }
            return super.toString();
        }
    }
}

