/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.gateway.model.GCompleteDealModel;
import ru.tinkoff.tisdk.utils.CommonUtils;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class CompleteDealParamsBuilder
extends ParamsBuilder {
    private final Deal deal;
    private final FullQuoteData fullQuoteData;
    private final double kbm;

    public CompleteDealParamsBuilder(@NotNull Deal deal, @NotNull FullQuoteData fullQuoteData, double kbm) {
        this.deal = deal;
        this.fullQuoteData = fullQuoteData;
        this.kbm = kbm;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        String sts = null;
        if (this.fullQuoteData.getVehicleDocument().getTypeDocument() == VehicleDocument.TypeDocument.STS && !StringUtilsKt.isEmpty(this.fullQuoteData.getVehicleDocument().getSeriesNumber())) {
            sts = this.fullQuoteData.getVehicleDocument().getSeriesNumber();
        }
        String dealId = Preconditions.checkNotNull(this.deal.getId());
        return new Gson().toJson((Object)new GCompleteDealModel(this.fullQuoteData.getVehicleDocument().getLicensePlate(), sts, this.fullQuoteData.getDrivers().getLicense(), CommonUtils.getRegionFromKladr(this.fullQuoteData.getOwner().getRegisteredAddress().getRegionKladr()), this.deal.getSetNumber(), dealId, this.fullQuoteData.getVehicleDocument().getVin(), this.fullQuoteData.getInsurer().getPhone().getValue(), this.deal.getResult().getTotalPremium(), this.kbm, 365));
    }

    @Override
    @Nullable
    public Map<String, String> buildQueryParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("IntegrationId", this.createIntegrationId());
        return params;
    }
}

