/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 BC\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006!"}, d2={"Lru/tinkoff/tisdk/InsuranceConditions;", "Ljava/io/Serializable;", "effectiveDate", "Ljava/util/Date;", "expirationDate", "email", "", "numberDC", "expirationDC", "(Ljava/util/Date;Ljava/util/Date;Ljava/lang/String;Ljava/lang/String;Ljava/util/Date;)V", "getEffectiveDate", "()Ljava/util/Date;", "getEmail", "()Ljava/lang/String;", "getExpirationDC", "getExpirationDate", "isValid", "", "()Z", "getNumberDC", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "tisdk-domain"})
public final class InsuranceConditions
implements Serializable {
    @Nullable
    private final Date effectiveDate;
    @Nullable
    private final Date expirationDate;
    @Nullable
    private final String email;
    @Nullable
    private final String numberDC;
    @Nullable
    private final Date expirationDC;
    public static final int INSURANCE_DURATION_DAYS = 365;
    private static final int EFFECTIVE_DATE_DAY_LIMITER = 60;
    private static final int ONE_DAY = 1;
    private static final int EXPIRATION_DC_DATE_YEAR_LIMITER = 3;
    private static final String REGEXP_DC = "^([0-9]{15}|[0-9]{21})$";
    public static final Companion Companion = new Companion(null);

    public final boolean isValid() {
        return Companion.validateEffectiveDate(this.effectiveDate) && this.expirationDate != null && Contact.Companion.validateEmail(this.email) && (this.numberDC == null && this.expirationDC == null || Companion.validateDC(this.numberDC) && Companion.validateExpirationDC(this.expirationDC, this.effectiveDate));
    }

    @Nullable
    public final Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @Nullable
    public final Date getExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    @Nullable
    public final String getNumberDC() {
        return this.numberDC;
    }

    @Nullable
    public final Date getExpirationDC() {
        return this.expirationDC;
    }

    @JvmOverloads
    public InsuranceConditions(@Nullable Date effectiveDate, @Nullable Date expirationDate, @Nullable String email, @Nullable String numberDC, @Nullable Date expirationDC) {
        this.effectiveDate = effectiveDate;
        this.expirationDate = expirationDate;
        this.email = email;
        this.numberDC = numberDC;
        this.expirationDC = expirationDC;
    }

    @JvmOverloads
    public /* synthetic */ InsuranceConditions(Date date, Date date2, String string, String string2, Date date3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            date = null;
        }
        if ((n & 2) != 0) {
            date2 = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            date3 = null;
        }
        this(date, date2, string, string2, date3);
    }

    @JvmOverloads
    public InsuranceConditions(@Nullable Date effectiveDate, @Nullable Date expirationDate, @Nullable String email, @Nullable String numberDC) {
        this(effectiveDate, expirationDate, email, numberDC, null, 16, null);
    }

    @JvmOverloads
    public InsuranceConditions(@Nullable Date effectiveDate, @Nullable Date expirationDate, @Nullable String email) {
        this(effectiveDate, expirationDate, email, null, null, 24, null);
    }

    @JvmOverloads
    public InsuranceConditions(@Nullable Date effectiveDate, @Nullable Date expirationDate) {
        this(effectiveDate, expirationDate, null, null, null, 28, null);
    }

    @JvmOverloads
    public InsuranceConditions(@Nullable Date effectiveDate) {
        this(effectiveDate, null, null, null, null, 30, null);
    }

    @JvmOverloads
    public InsuranceConditions() {
        this(null, null, null, null, null, 31, null);
    }

    @Nullable
    public final Date component1() {
        return this.effectiveDate;
    }

    @Nullable
    public final Date component2() {
        return this.expirationDate;
    }

    @Nullable
    public final String component3() {
        return this.email;
    }

    @Nullable
    public final String component4() {
        return this.numberDC;
    }

    @Nullable
    public final Date component5() {
        return this.expirationDC;
    }

    @NotNull
    public final InsuranceConditions copy(@Nullable Date effectiveDate, @Nullable Date expirationDate, @Nullable String email, @Nullable String numberDC, @Nullable Date expirationDC) {
        return new InsuranceConditions(effectiveDate, expirationDate, email, numberDC, expirationDC);
    }

    @NotNull
    public static /* synthetic */ InsuranceConditions copy$default(InsuranceConditions insuranceConditions, Date date, Date date2, String string, String string2, Date date3, int n, Object object) {
        if ((n & 1) != 0) {
            date = insuranceConditions.effectiveDate;
        }
        if ((n & 2) != 0) {
            date2 = insuranceConditions.expirationDate;
        }
        if ((n & 4) != 0) {
            string = insuranceConditions.email;
        }
        if ((n & 8) != 0) {
            string2 = insuranceConditions.numberDC;
        }
        if ((n & 0x10) != 0) {
            date3 = insuranceConditions.expirationDC;
        }
        return insuranceConditions.copy(date, date2, string, string2, date3);
    }

    @NotNull
    public String toString() {
        return "InsuranceConditions(effectiveDate=" + this.effectiveDate + ", expirationDate=" + this.expirationDate + ", email=" + this.email + ", numberDC=" + this.numberDC + ", expirationDC=" + this.expirationDC + ")";
    }

    public int hashCode() {
        Date date = this.effectiveDate;
        Date date2 = this.expirationDate;
        String string = this.email;
        String string2 = this.numberDC;
        Date date3 = this.expirationDC;
        return ((((date != null ? ((Object)date).hashCode() : 0) * 31 + (date2 != null ? ((Object)date2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (date3 != null ? ((Object)date3).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof InsuranceConditions)) break block3;
                InsuranceConditions insuranceConditions = (InsuranceConditions)object;
                if (!Intrinsics.areEqual((Object)this.effectiveDate, (Object)insuranceConditions.effectiveDate) || !Intrinsics.areEqual((Object)this.expirationDate, (Object)insuranceConditions.expirationDate) || !Intrinsics.areEqual((Object)this.email, (Object)insuranceConditions.email) || !Intrinsics.areEqual((Object)this.numberDC, (Object)insuranceConditions.numberDC) || !Intrinsics.areEqual((Object)this.expirationDC, (Object)insuranceConditions.expirationDC)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tJ\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/tinkoff/tisdk/InsuranceConditions$Companion;", "", "()V", "EFFECTIVE_DATE_DAY_LIMITER", "", "EXPIRATION_DC_DATE_YEAR_LIMITER", "INSURANCE_DURATION_DAYS", "ONE_DAY", "REGEXP_DC", "", "validateDC", "", "numberDC", "validateEffectiveDate", "effectiveDate", "Ljava/util/Date;", "validateExpirationDC", "expirationDC", "tisdk-domain"})
    public static final class Companion {
        public final boolean validateEffectiveDate(@Nullable Date effectiveDate) {
            if (effectiveDate == null) {
                return false;
            }
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            if (effectiveDate.compareTo(new Date()) <= 0) {
                return false;
            }
            Calendar calendar = c;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
            calendar.setTime(new Date());
            c.add(5, 60);
            return effectiveDate.compareTo(c.getTime()) <= 0;
        }

        public final boolean validateDC(@Nullable String numberDC) {
            if (StringUtilsKt.isEmpty(numberDC)) {
                return false;
            }
            Pattern pattern = Pattern.compile(InsuranceConditions.REGEXP_DC);
            String string = numberDC;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }

        public final boolean validateExpirationDC(@Nullable Date expirationDC, @Nullable Date effectiveDate) {
            if (expirationDC == null) {
                return false;
            }
            if (effectiveDate != null) {
                Calendar c;
                Calendar calendar = c = Calendar.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
                calendar.setTime(effectiveDate);
                c.add(5, 1);
                if (expirationDC.compareTo(c.getTime()) <= 0) {
                    return false;
                }
                c.setTime(new Date());
                c.add(1, 3);
                return expirationDC.compareTo(c.getTime()) <= 0;
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

