/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.PrePriceUseCase;
import ru.tinkoff.tisdk.QuickQuoteData;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.carreference.model.VehicleProperties;
import ru.tinkoff.tisdk.carreference.model.VehicleProperty;
import ru.tinkoff.tisdk.carreference.model.Year;
import ru.tinkoff.tisdk.utils.CommonUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/tinkoff/tisdk/PrePriceUseCaseImpl;", "Lru/tinkoff/tisdk/PrePriceUseCase;", "apiGateway", "Lru/tinkoff/tisdk/ApiGateway;", "(Lru/tinkoff/tisdk/ApiGateway;)V", "calculatePrice", "Lru/tinkoff/tisdk/InsuranceRate;", "data", "Lru/tinkoff/tisdk/QuickQuoteData;", "vehicle", "Lru/tinkoff/tisdk/Vehicle;", "isVehicleDetailsUpdateRequired", "", "updateVehicleDetailsIfPossible", "", "address", "Lru/tinkoff/tisdk/address/Address;", "tisdk-domain"})
public final class PrePriceUseCaseImpl
implements PrePriceUseCase {
    private final ApiGateway apiGateway;

    @Override
    @NotNull
    public InsuranceRate calculatePrice(@NotNull Vehicle vehicle) {
        Intrinsics.checkParameterIsNotNull((Object)vehicle, (String)"vehicle");
        return this.calculatePrice(new QuickQuoteData(null, vehicle, 1, null));
    }

    @Override
    @NotNull
    public InsuranceRate calculatePrice(@NotNull QuickQuoteData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Vehicle vehicle = data.getVehicle();
        Serializable serializable = vehicle;
        if ((serializable != null && (serializable = ((Vehicle)serializable).getProperties()) != null ? ((VehicleProperties)serializable).getMaker() : null) == null || vehicle.getProperties().getModel() == null) {
            throw (Throwable)new IllegalStateException();
        }
        if (this.isVehicleDetailsUpdateRequired(vehicle)) {
            this.updateVehicleDetailsIfPossible(vehicle, data.getCity());
        }
        InsuranceRate insuranceRate = this.apiGateway.prePricing(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)insuranceRate, (String)"apiGateway.prePricing(data)");
        return insuranceRate;
    }

    private final boolean isVehicleDetailsUpdateRequired(Vehicle vehicle) {
        VehicleDetails vehicleDetails = vehicle.getDetails();
        if (vehicleDetails == null) {
            return true;
        }
        VehicleDetails details = vehicleDetails;
        return details.getPrice() <= 0.0 || StringsKt.isBlank((CharSequence)details.getVehicleId()) || StringsKt.isBlank((CharSequence)details.getGroupId());
    }

    private final void updateVehicleDetailsIfPossible(Vehicle vehicle, Address address) {
        String string;
        Integer n;
        int it;
        VehicleProperties properties = vehicle.getProperties();
        Object object = properties.getModel();
        if (object == null || (object = ((VehicleProperty)object).getId()) == null) {
            return;
        }
        Object modelId = object;
        Serializable serializable = properties.getYear();
        if (serializable == null || (serializable = (it = ((Number)(n = Integer.valueOf(((Year)serializable).getIntValue()))).intValue()) > 1900 ? n : null) == null) {
            return;
        }
        int year = (Integer)serializable;
        Object object2 = properties.getAutobox();
        if (object2 == null || (object2 = ((VehicleProperty)object2).getId()) == null) {
            return;
        }
        Object autoboxId = object2;
        Object object3 = properties.getEngine();
        if (object3 == null || (object3 = ((VehicleProperty)object3).getId()) == null) {
            return;
        }
        Object engineId = object3;
        Object object4 = properties.getGearbox();
        if (object4 == null || (object4 = ((VehicleProperty)object4).getId()) == null) {
            return;
        }
        Object gearboxId = object4;
        Object object5 = address;
        if (object5 != null && (object5 = ((Address)object5).getRegionKladr()) != null) {
            Object object6;
            Object it2 = object6 = object5;
            string = CommonUtils.getRegionFromKladr((String)it2);
        } else {
            string = null;
        }
        String region = string;
        vehicle.setDetails(this.apiGateway.queryVehicleDetails((String)modelId, year, (String)autoboxId, (String)engineId, (String)gearboxId, region));
    }

    public PrePriceUseCaseImpl(@NotNull ApiGateway apiGateway) {
        Intrinsics.checkParameterIsNotNull((Object)apiGateway, (String)"apiGateway");
        this.apiGateway = apiGateway;
    }
}

