/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.InsuranceConditions;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuCarDocument;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuContact;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuCreateCalcModel;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuDriversInfo;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuLicense;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuPartner;
import ru.tinkoff.tisdk.gateway.model.thirdparty.SravniRuPassport;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.subject.Drivers;
import ru.tinkoff.tisdk.subject.FullDriverLicense;
import ru.tinkoff.tisdk.subject.Insurer;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class SravniRuCalculationParamsBuilder
extends ParamsBuilder {
    private static final String SRAVNI_RU_DATE_FORMAT = "yyyy-MM-dd";
    private final Vehicle vehicle;
    private final FullQuoteData fullQuoteData;

    public SravniRuCalculationParamsBuilder(@NotNull Vehicle vehicle, @NotNull FullQuoteData fullQuoteData) {
        this.vehicle = vehicle;
        this.fullQuoteData = fullQuoteData;
    }

    @Override
    @NotNull
    public String buildBodyParams() {
        SravniRuDriversInfo driversInfo;
        Drivers drivers = this.fullQuoteData.getDrivers();
        VehicleDocument vehicleDocument = this.fullQuoteData.getVehicleDocument();
        InsuranceConditions conditions = this.fullQuoteData.getConditions();
        Insurer insurer = this.fullQuoteData.getInsurer();
        Contact owner = this.fullQuoteData.getOwner();
        if (drivers.isMultiple() || drivers.getDrivers() == null) {
            driversInfo = new SravniRuDriversInfo(new SravniRuContact(owner.getFirstName(), owner.getLastName(), owner.getMiddleName(), DateUtils.formatDate(owner.getBirthDate(), SRAVNI_RU_DATE_FORMAT), new SravniRuPassport(owner.getPassport().getSeries(), owner.getPassport().getNumber(), DateUtils.formatDate(owner.getPassport().getDateIssue(), SRAVNI_RU_DATE_FORMAT)), null, null, null, null));
        } else {
            SravniRuContact[] sravniRuDrivers = new SravniRuContact[drivers.getDrivers().length];
            for (int i = 0; i < drivers.getDrivers().length; ++i) {
                Driver driver = drivers.getDrivers()[i];
                sravniRuDrivers[i] = new SravniRuContact(driver.getFirstName(), driver.getLastName(), driver.getMiddleName(), DateUtils.formatDate(driver.getBirthDate(), SRAVNI_RU_DATE_FORMAT), null, new SravniRuLicense(((FullDriverLicense)driver.getDriverLicense()).getSeries(), ((FullDriverLicense)driver.getDriverLicense()).getNumber(), DateUtils.formatDate(((FullDriverLicense)driver.getDriverLicense()).getIssueDate(), SRAVNI_RU_DATE_FORMAT)), null, null, null);
            }
            driversInfo = new SravniRuDriversInfo(sravniRuDrivers);
        }
        return new Gson().toJson((Object)new SravniRuCreateCalcModel(this.vehicle.getProperties().getMaker().getId(), this.vehicle.getProperties().getYear().getIntValue(), this.vehicle.getProperties().getModel().getId(), this.vehicle.getProperties().getAutobox().getName(), this.vehicle.getProperties().getGearbox().getId(), this.vehicle.getProperties().getEngine().getName(), vehicleDocument.getVin(), vehicleDocument.getLicensePlate(), DateUtils.formatDate(conditions.getEffectiveDate(), SRAVNI_RU_DATE_FORMAT), new SravniRuCarDocument(vehicleDocument.getSeries(), vehicleDocument.getNumber(), DateUtils.formatDate(vehicleDocument.getIssueDate(), SRAVNI_RU_DATE_FORMAT), vehicleDocument.getTypeDocument() == VehicleDocument.TypeDocument.STS ? 2 : 1), new SravniRuContact(insurer.getFirstName(), insurer.getLastName(), insurer.getMiddleName(), DateUtils.formatDate(insurer.getBirthDate(), SRAVNI_RU_DATE_FORMAT), new SravniRuPassport(insurer.getPassport().getSeries(), insurer.getPassport().getNumber(), DateUtils.formatDate(insurer.getPassport().getDateIssue(), SRAVNI_RU_DATE_FORMAT)), null, insurer.getPhone().getValue(), conditions.getEmail(), insurer.getRegisteredAddress().getAddress()), new SravniRuContact(owner.getFirstName(), owner.getLastName(), owner.getMiddleName(), DateUtils.formatDate(owner.getBirthDate(), SRAVNI_RU_DATE_FORMAT), new SravniRuPassport(owner.getPassport().getSeries(), owner.getPassport().getNumber(), DateUtils.formatDate(owner.getPassport().getDateIssue(), SRAVNI_RU_DATE_FORMAT)), null, null, null, owner.getRegisteredAddress().getAddress()), new SravniRuPartner(), driversInfo));
    }

    @Override
    @NotNull
    public Map<String, String> buildQueryParams() throws Exception {
        return super.buildQueryParams();
    }
}

