/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.subject;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Subject$Gender$WhenMappings;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 4*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004:\u000245B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB1\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u000102H\u0096\u0002J\b\u00103\u001a\u00020\rH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u0004\u0018\u00018\u0000X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018R\u0013\u0010&\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0018R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00066"}, d2={"Lru/tinkoff/tisdk/subject/Subject;", "DriverLicenseType", "Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "CopyIdsType", "Ljava/io/Serializable;", "fio", "", "birthDate", "Ljava/util/Date;", "gender", "Lru/tinkoff/tisdk/subject/Subject$Gender;", "(Ljava/lang/String;Ljava/util/Date;Lru/tinkoff/tisdk/subject/Subject$Gender;)V", "subjectNumber", "", "(ILjava/lang/String;Ljava/util/Date;Lru/tinkoff/tisdk/subject/Subject$Gender;)V", "getBirthDate", "()Ljava/util/Date;", "driverLicense", "getDriverLicense", "()Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "setDriverLicense", "(Lru/tinkoff/tisdk/subject/PartialDriverLicense;)V", "Lru/tinkoff/tisdk/subject/PartialDriverLicense;", "getFio", "()Ljava/lang/String;", "firstName", "getFirstName", "getGender", "()Lru/tinkoff/tisdk/subject/Subject$Gender;", "id", "getId", "setId", "(Ljava/lang/String;)V", "isValid", "", "()Z", "lastName", "getLastName", "middleName", "getMiddleName", "getSubjectNumber", "()I", "setSubjectNumber", "(I)V", "copyIds", "", "subject", "(Lru/tinkoff/tisdk/subject/Subject;)V", "equals", "other", "", "hashCode", "Companion", "Gender", "tisdk-domain"})
public class Subject<DriverLicenseType extends PartialDriverLicense, CopyIdsType extends Subject<DriverLicenseType, CopyIdsType>>
implements Serializable {
    @Nullable
    private String id;
    @Nullable
    private final Gender gender;
    @Nullable
    private DriverLicenseType driverLicense;
    private int subjectNumber;
    @Nullable
    private final String fio;
    @Nullable
    private final Date birthDate;
    public static final int SUBJECT_NUMBER_INSURER = 1;
    public static final int SUBJECT_NUMBER_OWNER = 2;
    public static final int SUBJECT_NUMBER_DRIVER1 = 3;
    public static final int SUBJECT_NUMBER_DRIVER2 = 4;
    public static final int SUBJECT_NUMBER_DRIVER3 = 5;
    public static final int SUBJECT_NUMBER_DRIVER4 = 6;
    public static final int SUBJECT_NUMBER_DRIVER5 = 7;
    private static final int EIGHTEEN_YEARS = 18;
    private static final int MIN_BIRTHDATE_YEAR = 1920;
    private static final int MIN_BIRTHDATE_MONTH = 0;
    private static final int MIN_BIRTHDATE_DAY = 1;
    private static final String LAST_NAME_SEPARATOR = "-";
    private static final String FIO_REGEXP = "^([\u0410-\u042f\u0401][\u0430-\u044f\u0451]+(?:-[\u0410-\u042f\u0401][\u0430-\u044f\u0451]+)?) ([\u0410-\u042f\u0401][\u0430-\u044f\u0451]+) ([\u0410-\u042f\u0401][\u0430-\u044f\u0451]+)$";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @Nullable
    public final String getLastName() {
        String string;
        if (Companion.validateFio(this.fio)) {
            String string2 = this.fio;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = Companion.splitFio(string2)[0];
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getFirstName() {
        String string;
        if (Companion.validateFio(this.fio)) {
            String string2 = this.fio;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = Companion.splitFio(string2)[1];
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getMiddleName() {
        String string;
        if (Companion.validateFio(this.fio)) {
            String string2 = this.fio;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = Companion.splitFio(string2)[2];
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final Gender getGender() {
        return this.gender;
    }

    public boolean isValid() {
        return Companion.validateFio(this.fio) && Companion.validateBirthDate(this.birthDate);
    }

    @Nullable
    public DriverLicenseType getDriverLicense() {
        return this.driverLicense;
    }

    public void setDriverLicense(@Nullable DriverLicenseType DriverLicenseType) {
        this.driverLicense = DriverLicenseType;
    }

    public void copyIds(@NotNull CopyIdsType subject) {
        Intrinsics.checkParameterIsNotNull(subject, (String)"subject");
        this.id = ((Subject)subject).id;
        if (((Subject)subject).getDriverLicense() != null && this.getDriverLicense() != null) {
            DriverLicenseType DriverLicenseType = this.getDriverLicense();
            if (DriverLicenseType == null) {
                Intrinsics.throwNpe();
            }
            DriverLicenseType DriverLicenseType2 = ((Subject)subject).getDriverLicense();
            if (DriverLicenseType2 == null) {
                Intrinsics.throwNpe();
            }
            ((PartialDriverLicense)DriverLicenseType).setId(((PartialDriverLicense)DriverLicenseType2).getId());
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        Subject subject = (Subject)other;
        if (this.getLastName() != null ? Intrinsics.areEqual((Object)this.getLastName(), (Object)subject.getLastName()) ^ true : subject.getLastName() != null) {
            return false;
        }
        if (this.getFirstName() != null ? Intrinsics.areEqual((Object)this.getFirstName(), (Object)subject.getFirstName()) ^ true : subject.getFirstName() != null) {
            return false;
        }
        if (this.getMiddleName() != null ? Intrinsics.areEqual((Object)this.getMiddleName(), (Object)subject.getMiddleName()) ^ true : subject.getMiddleName() != null) {
            return false;
        }
        if (this.birthDate != null ? Intrinsics.areEqual((Object)this.birthDate, (Object)subject.birthDate) ^ true : subject.birthDate != null) {
            return false;
        }
        if (this.gender != subject.gender) {
            return false;
        }
        return this.getDriverLicense() != null ? Intrinsics.areEqual(this.getDriverLicense(), subject.getDriverLicense()) : subject.getDriverLicense() == null;
    }

    public int hashCode() {
        int n;
        String string = this.getLastName();
        int result = string != null ? string.hashCode() : 0;
        String string2 = this.getFirstName();
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        String string3 = this.getMiddleName();
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        Date date = this.birthDate;
        result = 31 * result + (date != null ? date.hashCode() : 0);
        Gender gender = this.gender;
        result = 31 * result + (gender != null ? gender.hashCode() : 0);
        if (this.getDriverLicense() != null) {
            DriverLicenseType DriverLicenseType = this.getDriverLicense();
            if (DriverLicenseType == null) {
                Intrinsics.throwNpe();
            }
            n = ((PartialDriverLicense)DriverLicenseType).hashCode();
        } else {
            n = 0;
        }
        result = 31 * result + n;
        return result;
    }

    public final int getSubjectNumber() {
        return this.subjectNumber;
    }

    public final void setSubjectNumber(int n) {
        this.subjectNumber = n;
    }

    @Nullable
    public final String getFio() {
        return this.fio;
    }

    @Nullable
    public final Date getBirthDate() {
        return this.birthDate;
    }

    public Subject(int subjectNumber, @Nullable String fio, @Nullable Date birthDate, @Nullable Gender gender) {
        this.subjectNumber = subjectNumber;
        this.fio = fio;
        this.birthDate = birthDate;
        Subject subject = this;
        Gender gender2 = gender;
        if (gender2 == null) {
            String string = this.getMiddleName();
            if (string != null) {
                String string2 = string;
                Subject subject2 = subject;
                String it = string2;
                Gender gender3 = Gender.Companion.extractGender(it);
                subject = subject2;
                gender2 = gender3;
            } else {
                gender2 = null;
            }
        }
        subject.gender = gender2;
    }

    public /* synthetic */ Subject(int n, String string, Date date, Gender gender, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            date = null;
        }
        if ((n2 & 8) != 0) {
            gender = null;
        }
        this(n, string, date, gender);
    }

    public Subject(@NotNull String fio, @NotNull Date birthDate, @Nullable Gender gender) {
        Intrinsics.checkParameterIsNotNull((Object)fio, (String)"fio");
        Intrinsics.checkParameterIsNotNull((Object)birthDate, (String)"birthDate");
        this(0, fio, birthDate, gender);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lru/tinkoff/tisdk/subject/Subject$Gender;", "", "(Ljava/lang/String;I)V", "toString", "", "MALE", "FEMALE", "Companion", "tisdk-domain"})
    public static final class Gender
    extends Enum<Gender> {
        public static final /* enum */ Gender MALE;
        public static final /* enum */ Gender FEMALE;
        private static final /* synthetic */ Gender[] $VALUES;
        private static final String GENDER_MALE_RU = "\u041c\u0443\u0436\u0441\u043a\u043e\u0439";
        private static final String GENDER_MALE_EN = "Male";
        private static final String GENDER_FEMALE_RU = "\u0416\u0435\u043d\u0441\u043a\u0438\u0439";
        private static final String GENDER_FEMALE_EN = "Female";
        private static final String MIDDLE_NAME_MALE_ENDING = "\u0432\u0438\u0447";
        public static final Companion Companion;

        static {
            Gender[] genderArray = new Gender[2];
            Gender[] genderArray2 = genderArray;
            genderArray[0] = MALE = new Gender();
            genderArray[1] = FEMALE = new Gender();
            $VALUES = genderArray;
            Companion = new Companion(null);
        }

        @NotNull
        public String toString() {
            String string;
            switch (Subject$Gender$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = GENDER_MALE_RU;
                    break;
                }
                case 2: {
                    string = GENDER_FEMALE_RU;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public static Gender[] values() {
            return (Gender[])$VALUES.clone();
        }

        public static Gender valueOf(String string) {
            return Enum.valueOf(Gender.class, string);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lru/tinkoff/tisdk/subject/Subject$Gender$Companion;", "", "()V", "GENDER_FEMALE_EN", "", "GENDER_FEMALE_RU", "GENDER_MALE_EN", "GENDER_MALE_RU", "MIDDLE_NAME_MALE_ENDING", "extractGender", "Lru/tinkoff/tisdk/subject/Subject$Gender;", "middleName", "fromValue", "gender", "tisdk-domain"})
        public static final class Companion {
            @Nullable
            public final Gender fromValue(@NotNull String gender) {
                Intrinsics.checkParameterIsNotNull((Object)gender, (String)"gender");
                return StringsKt.equals((String)Gender.GENDER_MALE_RU, (String)gender, (boolean)true) || StringsKt.equals((String)Gender.GENDER_MALE_EN, (String)gender, (boolean)true) ? MALE : (StringsKt.equals((String)Gender.GENDER_FEMALE_RU, (String)gender, (boolean)true) || StringsKt.equals((String)Gender.GENDER_FEMALE_EN, (String)gender, (boolean)true) ? FEMALE : null);
            }

            @NotNull
            public final Gender extractGender(@NotNull String middleName) {
                Intrinsics.checkParameterIsNotNull((Object)middleName, (String)"middleName");
                return StringsKt.endsWith$default((String)middleName, (String)Gender.MIDDLE_NAME_MALE_ENDING, (boolean)false, (int)2, null) ? MALE : FEMALE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lru/tinkoff/tisdk/subject/Subject$Companion;", "", "()V", "EIGHTEEN_YEARS", "", "FIO_REGEXP", "", "LAST_NAME_SEPARATOR", "MIN_BIRTHDATE_DAY", "MIN_BIRTHDATE_MONTH", "MIN_BIRTHDATE_YEAR", "SUBJECT_NUMBER_DRIVER1", "SUBJECT_NUMBER_DRIVER2", "SUBJECT_NUMBER_DRIVER3", "SUBJECT_NUMBER_DRIVER4", "SUBJECT_NUMBER_DRIVER5", "SUBJECT_NUMBER_INSURER", "SUBJECT_NUMBER_OWNER", "capitalizeName", "name", "splitFio", "", "fio", "(Ljava/lang/String;)[Ljava/lang/String;", "validateBirthDate", "", "birthDate", "Ljava/util/Date;", "validateFio", "tisdk-domain"})
    public static final class Companion {
        public final boolean validateFio(@Nullable String fio) {
            if (StringUtilsKt.isEmpty(fio)) {
                return false;
            }
            Matcher matcher = Pattern.compile(Subject.FIO_REGEXP).matcher(fio);
            return matcher.matches();
        }

        public final boolean validateBirthDate(@Nullable Date birthDate) {
            if (birthDate == null) {
                return false;
            }
            Calendar c = Calendar.getInstance();
            c.add(1, -18);
            Calendar calendar = c;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
            if (birthDate.compareTo(calendar.getTime()) > 0) {
                return false;
            }
            c.set(1920, 0, 1, 0, 0, 0);
            c.set(14, 0);
            return birthDate.compareTo(c.getTime()) >= 0;
        }

        @NotNull
        public final String[] splitFio(@NotNull String fio) {
            String lastName;
            Intrinsics.checkParameterIsNotNull((Object)fio, (String)"fio");
            Matcher matcher = Pattern.compile(Subject.FIO_REGEXP).matcher(fio);
            matcher.matches();
            String string = lastName = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lastName");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)Subject.LAST_NAME_SEPARATOR, (boolean)false, (int)2, null)) {
                List list;
                Collection $receiver$iv;
                Object object = lastName;
                String string2 = Subject.LAST_NAME_SEPARATOR;
                string2 = new Regex(string2);
                int n = 0;
                object = string2.split((CharSequence)object, n);
                if (!$receiver$iv.isEmpty()) {
                    ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        if (StringUtilsKt.isEmpty(it)) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] partsLastName = stringArray;
                String onePart = this.capitalizeName(partsLastName[0]);
                String twoPart = this.capitalizeName(partsLastName[1]);
                lastName = onePart + Subject.LAST_NAME_SEPARATOR + twoPart;
            }
            String string3 = matcher.group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(2)");
            String firstName = this.capitalizeName(string3);
            String string4 = matcher.group(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"matcher.group(3)");
            String middleName = this.capitalizeName(string4);
            String[] stringArray = new String[3];
            String string5 = lastName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"lastName");
            stringArray[0] = string5;
            stringArray[1] = firstName;
            stringArray[2] = middleName;
            return stringArray;
        }

        private final String capitalizeName(String name) {
            String string;
            if (StringUtilsKt.isEmpty(name)) {
                string = name;
            } else {
                String string2;
                String string3 = name;
                int n = 1;
                StringBuilder stringBuilder = new StringBuilder().append(String.valueOf(Character.toTitleCase(name.charAt(0))));
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                String string6 = string3 = (string2 = string5);
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                string2 = string7;
                string = stringBuilder.append(string2).toString();
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

