/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class DateUtils {
    private static final String SMART_DATE_FORMAT = "dd.MM.yyyy";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static int yearsBetween(@NotNull Date date1, @NotNull Date date2) {
        Calendar calendar1 = DateUtils.getCalendar();
        calendar1.setTime(date1);
        Calendar calendar2 = DateUtils.getCalendar();
        calendar2.setTime(date2);
        int years = calendar2.get(1) - calendar1.get(1);
        if (calendar1.get(2) > calendar2.get(2) || calendar1.get(2) == calendar2.get(2) && calendar1.get(5) > calendar2.get(5)) {
            --years;
        }
        return years;
    }

    @NotNull
    public static String formatSmartDate(Date date) {
        return DateUtils.formatDate(date, SMART_DATE_FORMAT);
    }

    @NotNull
    public static String formatDate(@NotNull Date date) {
        return DateUtils.formatDate(date, DATE_FORMAT);
    }

    @NotNull
    public static String formatDate(@NotNull Date d, @NotNull String template) {
        SimpleDateFormat format = new SimpleDateFormat(template, Locale.getDefault());
        return format.format(d);
    }

    @NotNull
    public static Date parseDate(@NotNull String date) throws ParseException {
        return DateUtils.parseDate(date, DATE_FORMAT);
    }

    @NotNull
    public static Date addDays(@NotNull Date date, int days) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    @NotNull
    public static Date addMonths(@NotNull Date date, int months) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    @NotNull
    public static Date addYears(@NotNull Date date, int years) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    @NotNull
    private static Date parseDate(@NotNull String date, @NotNull String pattern) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.getDefault());
        return format.parse(date);
    }

    public static int getYear(@NotNull Date date) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }
}

