/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.VehicleKt;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.carreference.model.Autobox;
import ru.tinkoff.tisdk.carreference.model.Engine;
import ru.tinkoff.tisdk.carreference.model.Gearbox;
import ru.tinkoff.tisdk.carreference.model.Model;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.carreference.model.Year;
import ru.tinkoff.tisdk.utils.CommonUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lru/tinkoff/tisdk/BuyingProcess;", "", "apiGateway", "Lru/tinkoff/tisdk/ApiGateway;", "(Lru/tinkoff/tisdk/ApiGateway;)V", "getApiGateway", "()Lru/tinkoff/tisdk/ApiGateway;", "updateVehicleDetailsIfNeeded", "", "vehicle", "Lru/tinkoff/tisdk/Vehicle;", "city", "Lru/tinkoff/tisdk/address/Address;", "tisdk-domain"})
public class BuyingProcess {
    @NotNull
    private final ApiGateway apiGateway;

    protected final void updateVehicleDetailsIfNeeded(@NotNull Vehicle vehicle, @Nullable Address city) {
        Intrinsics.checkParameterIsNotNull((Object)vehicle, (String)"vehicle");
        if (VehicleKt.isValid(vehicle.getProperties())) {
            VehicleDetails vehicleDetails = vehicle.getDetails();
            if (vehicleDetails == null || !VehicleKt.isValid(vehicleDetails)) {
                String string;
                ApiGateway apiGateway = this.apiGateway;
                Model model = vehicle.getProperties().getModel();
                if (model == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = model.getId();
                Year year = vehicle.getProperties().getYear();
                if (year == null) {
                    Intrinsics.throwNpe();
                }
                int n = year.getIntValue();
                Autobox autobox = vehicle.getProperties().getAutobox();
                if (autobox == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = autobox.getId();
                Engine engine = vehicle.getProperties().getEngine();
                if (engine == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = engine.getId();
                Gearbox gearbox = vehicle.getProperties().getGearbox();
                if (gearbox == null) {
                    Intrinsics.throwNpe();
                }
                String string5 = gearbox.getId();
                Object object = city;
                if (object != null && (object = ((Address)object).getRegionKladr()) != null) {
                    Object object2 = object;
                    String string6 = string5;
                    String string7 = string4;
                    String string8 = string3;
                    int n2 = n;
                    String string9 = string2;
                    ApiGateway apiGateway2 = apiGateway;
                    Object it = object2;
                    String string10 = CommonUtils.getRegionFromKladr((String)it);
                    apiGateway = apiGateway2;
                    string2 = string9;
                    n = n2;
                    string3 = string8;
                    string4 = string7;
                    string5 = string6;
                    string = string10;
                } else {
                    string = null;
                }
                VehicleDetails details = apiGateway.queryVehicleDetails(string2, n, string3, string4, string5, string);
                vehicle.setDetails(details);
            }
        }
    }

    @NotNull
    protected final ApiGateway getApiGateway() {
        return this.apiGateway;
    }

    public BuyingProcess(@NotNull ApiGateway apiGateway) {
        Intrinsics.checkParameterIsNotNull((Object)apiGateway, (String)"apiGateway");
        this.apiGateway = apiGateway;
    }
}

