/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class Config {
    private static final String BASE_URL_TCS = "https://api.tinkoff.ru/";
    private static final String BASE_URL_TCS_TEST = "https://www-qa2.tcsbank.ru/api/";
    private static final String BASE_URL_INSURANCE = "https://api.tinkoffinsurance.ru/";
    private static final String BASE_URL_INSURANCE_TEST = "https://api-test.tinkoffinsurance.ru/";
    private static final String BASE_URL_SRAVNI_RU = "https://api.sravni.ru/";
    public static final String SRAVNI_RU_URL_FORMAT = "https://www.sravni.ru/osago/?searchId=%s&hash=%s&marker=%s";
    public static final String SRAVNI_RU_URL_FORMAT_DEFAULT = "https://www.sravni.ru/osago/?marker=%s";
    private static final int PORT = 0;
    private static final int PORT_TEST = 38002;
    private static boolean debug = false;
    private static String insuranceHost;
    private static Integer insurancePort;
    private static String baseUrlTcs;
    private static String baseUrlSravni;
    private static String sravniUrl;
    private static String sravniUrlDefault;
    private static String marketingSource;
    private static String marketingChannel;
    private static String source;
    private static String headerSecureKey;

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        Config.debug = debug;
    }

    public static int getInsurancePort() {
        if (insurancePort != null) {
            return insurancePort;
        }
        return Config.isDebug() ? 38002 : 0;
    }

    public static void setInsurancePort(int insurancePort) {
        Config.insurancePort = insurancePort;
    }

    @NotNull
    public static String getBaseUrlInsurance() {
        if (StringUtilsKt.isNotBlank(insuranceHost)) {
            return insuranceHost;
        }
        return Config.isDebug() ? BASE_URL_INSURANCE_TEST : BASE_URL_INSURANCE;
    }

    public static void setBaseUrlInsurance(@NotNull String baseUrlInsurance) {
        insuranceHost = Preconditions.checkNotNull(baseUrlInsurance);
    }

    @NotNull
    public static String getMarketingSource() {
        return marketingSource;
    }

    public static void setMarketingSource(@NotNull String marketingSource) {
        Config.marketingSource = marketingSource;
    }

    @NotNull
    public static String getMarketingChannel() {
        return marketingChannel;
    }

    public static void setMarketingChannel(@NotNull String marketingChannel) {
        Config.marketingChannel = marketingChannel;
    }

    @NotNull
    public static String getSource() {
        return source;
    }

    public static void setSource(@NotNull String source) {
        Config.source = source;
    }

    @NotNull
    public static String getBaseUrlTcs() {
        if (StringUtilsKt.isNotBlank(baseUrlTcs)) {
            return baseUrlTcs;
        }
        return Config.isDebug() ? BASE_URL_TCS_TEST : BASE_URL_TCS;
    }

    public static void setBaseUrlTcs(@NotNull String baseUrlTcs) {
        Config.baseUrlTcs = Preconditions.checkNotNull(baseUrlTcs);
    }

    public static void setBaseUrlSravni(@NotNull String baseUrlSravni) {
        Config.baseUrlSravni = Preconditions.checkNotNull(baseUrlSravni);
    }

    @NotNull
    public static String getBaseUrlSravni() {
        if (StringUtilsKt.isNotBlank(baseUrlSravni)) {
            return baseUrlSravni;
        }
        return BASE_URL_SRAVNI_RU;
    }

    public static String getSravniUrl() {
        return sravniUrl == null ? SRAVNI_RU_URL_FORMAT : sravniUrl;
    }

    public static String getSravniUrlDefault() {
        return sravniUrlDefault == null ? SRAVNI_RU_URL_FORMAT_DEFAULT : sravniUrlDefault;
    }

    public static void setSravniUrl(String sravniUrl) {
        Config.sravniUrl = sravniUrl;
    }

    public static void setSravniUrlDefault(String sravniUrlDefault) {
    }

    @Nullable
    public static String getHeaderSecureKey() {
        return headerSecureKey;
    }

    public static void setHeaderSecureKey(@Nullable String headerSecureKey) {
        Config.headerSecureKey = headerSecureKey;
    }

    static {
        marketingSource = "fines";
        marketingChannel = "fines";
        source = "tisdk_fines";
    }
}

