/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.carreference.gateway.common.exception;

import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class GatewayException
extends RuntimeException {
    private static final String RESULT_CODE_UNAUTHORIZED = "UnauthorizedError";
    private static final String RESULT_CODE_ACCESS_TOKEN_EXPIRED = "AccessTokenExpired";
    private static final String RESULT_CODE_ACCESS_TOKEN_WRONG = "WrongAccessToken";
    private static final String RESULT_CODE_WRONG_CODE = "AuthWrongCode";
    private static final String RESULT_CODE_CODE_ATTEMPTS_EXCEEDED = "AuthAttemptsLimitReachedError";
    private final String errorId;
    private final String domain;
    private final String resultCode;
    private final String message;

    public GatewayException(@NotNull String errorId, @NotNull String domain, @NotNull String resultCode, @NotNull String message) {
        if (StringUtilsKt.isEmpty(errorId)) {
            throw new IllegalArgumentException();
        }
        if (StringUtilsKt.isEmpty(domain)) {
            throw new IllegalArgumentException();
        }
        if (StringUtilsKt.isEmpty(resultCode)) {
            throw new IllegalArgumentException();
        }
        if (StringUtilsKt.isEmpty(message)) {
            throw new IllegalArgumentException();
        }
        this.errorId = errorId;
        this.domain = domain;
        this.resultCode = resultCode;
        this.message = message;
    }

    @NotNull
    public String getErrorId() {
        return this.errorId;
    }

    @NotNull
    public String getDomain() {
        return this.domain;
    }

    @NotNull
    public String getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public boolean isUnAuthorized() {
        return RESULT_CODE_UNAUTHORIZED.equals(this.resultCode);
    }

    public boolean isTokenExpired() {
        return RESULT_CODE_ACCESS_TOKEN_EXPIRED.equals(this.resultCode);
    }

    public boolean isTokenWrong() {
        return RESULT_CODE_ACCESS_TOKEN_WRONG.equals(this.resultCode);
    }

    public boolean isAuthWrongCode() {
        return RESULT_CODE_WRONG_CODE.equals(this.resultCode);
    }

    public boolean isAuthAttemptsExceeded() {
        return RESULT_CODE_CODE_ATTEMPTS_EXCEEDED.equals(this.resultCode);
    }
}

