/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.model;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.gateway.model.FileType;
import ru.tinkoff.tisdk.utils.Preconditions;

public class FileRequestBody
extends RequestBody {
    private final File file;

    public FileRequestBody(@NotNull File file) {
        Preconditions.checkNotNull(file);
        this.file = file;
    }

    public long contentLength() {
        return this.file.length();
    }

    public MediaType contentType() {
        FileType fileType = this.getFileType(this.file);
        if (fileType == null) {
            return null;
        }
        return fileType.getMediaType();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)new FileInputStream(this.file));
            sink.writeAll(source);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(source);
            throw throwable;
        }
        Util.closeQuietly((Closeable)source);
    }

    @NotNull
    public String getFileName() {
        return this.file.getName();
    }

    @Nullable
    private FileType getFileType(@NotNull File file) {
        String fileName = file.getName();
        int index = fileName.indexOf(46);
        return FileType.parse(index == -1 ? null : fileName.substring(index + 1));
    }
}

