/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.carreference.gateway.vehicle;

import java.util.List;
import java.util.Map;
import kotlin.Pair;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.Converter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.VehicleGateway;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.DefaultParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.MakerAndModelsParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.MakersParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.ModelsParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.ModificationsParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.YearsParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.MakerAndModelsConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.MakersConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.ModelsConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.ModificationsConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.YearsConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.search.AutoboxConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.search.EngineConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.search.GearboxConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.search.MakerConverter;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.search.ModelConverter;
import ru.tinkoff.tisdk.carreference.model.Autobox;
import ru.tinkoff.tisdk.carreference.model.Engine;
import ru.tinkoff.tisdk.carreference.model.Gearbox;
import ru.tinkoff.tisdk.carreference.model.Maker;
import ru.tinkoff.tisdk.carreference.model.Model;
import ru.tinkoff.tisdk.carreference.model.Modification;
import ru.tinkoff.tisdk.carreference.model.Year;
import ru.tinkoff.tisdk.gateway.Config;
import ru.tinkoff.tisdk.utils.Preconditions;

public class VehicleGatewayImpl
implements VehicleGateway {
    private static final String METHOD_MAKER_MODEL = "api/vehicle_search";
    private static final String METHOD_MODELS = "api/vehicle_search/model";
    private static final String METHOD_MAKERS = "api/vehicle_search/mark";
    private static final String METHOD_YEARS = "api/vehicle_search/years";
    private static final String METHOD_MODIFICATIONS = "api/vehicle_search/modifications";
    private static final String METHOD_SEARCH_MAKER = "api/vehicle_search/search/mark/%s";
    private static final String METHOD_SEARCH_MODEL = "api/vehicle_search/search/model/%s";
    private static final String METHOD_SEARCH_AUTOBOX = "api/vehicle_search/search/autobox/%s";
    private static final String METHOD_SEARCH_GEARBOX = "api/vehicle_search/search/gearbox/%s";
    private static final String METHOD_SEARCH_ENGINE = "api/vehicle_search/search/engine/%s";
    private final OkHttpClient httpClient;

    public VehicleGatewayImpl(@NotNull OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    @NotNull
    public List<Pair<Maker, Model>> queryMakerAndModels(@NotNull String query) throws Exception {
        Preconditions.checkNotNull(query);
        return this.requestGet(METHOD_MAKER_MODEL, new MakerAndModelsParamsBuilder(query).buildQueryParams(), new MakerAndModelsConverter());
    }

    @Override
    @NotNull
    public List<Maker> queryMakers(@NotNull String query) throws Exception {
        Preconditions.checkNotNull(query);
        return this.requestGet(METHOD_MAKERS, new MakersParamsBuilder(query).buildQueryParams(), new MakersConverter());
    }

    @Override
    @NotNull
    public List<Model> queryModels(@NotNull String query, @NotNull String makerId) throws Exception {
        Preconditions.checkNotNull(makerId);
        Preconditions.checkNotNull(query);
        return this.requestGet(METHOD_MODELS, new ModelsParamsBuilder(query, makerId).buildQueryParams(), new ModelsConverter());
    }

    @Override
    @NotNull
    public List<Year> queryYears(@NotNull String modelId) throws Exception {
        Preconditions.checkNotNull(modelId);
        return this.requestGet(METHOD_YEARS, new YearsParamsBuilder(modelId).buildQueryParams(), new YearsConverter());
    }

    @Override
    @NotNull
    public List<Modification> queryModifications(@NotNull String modelId, int year) throws Exception {
        Preconditions.checkNotNull(modelId);
        Preconditions.checkArgument(year > 0);
        return this.requestGet(METHOD_MODIFICATIONS, new ModificationsParamsBuilder(modelId, year).buildQueryParams(), new ModificationsConverter());
    }

    @Override
    @NotNull
    public Maker searchMaker(@NotNull String id) throws Exception {
        return this.requestGet(String.format(METHOD_SEARCH_MAKER, id), new DefaultParamsBuilder().buildQueryParams(), new MakerConverter());
    }

    @Override
    @NotNull
    public Model searchModel(@NotNull String id) throws Exception {
        return this.requestGet(String.format(METHOD_SEARCH_MODEL, id), new DefaultParamsBuilder().buildQueryParams(), new ModelConverter());
    }

    @Override
    @NotNull
    public Autobox searchAutobox(@NotNull String id) throws Exception {
        return this.requestGet(String.format(METHOD_SEARCH_AUTOBOX, id), new DefaultParamsBuilder().buildQueryParams(), new AutoboxConverter());
    }

    @Override
    @NotNull
    public Gearbox searchGearbox(@NotNull String id) throws Exception {
        return this.requestGet(String.format(METHOD_SEARCH_GEARBOX, id), new DefaultParamsBuilder().buildQueryParams(), new GearboxConverter());
    }

    @Override
    @NotNull
    public Engine searchEngine(@NotNull String id) throws Exception {
        return this.requestGet(String.format(METHOD_SEARCH_ENGINE, id), new DefaultParamsBuilder().buildQueryParams(), new EngineConverter());
    }

    private <T> T requestGet(@NotNull String method, @Nullable Map<String, String> params, @NotNull Converter<T, ?> parsePayload) throws Exception {
        Request request = this.getGetRequest(method, params);
        return this.request(request, parsePayload);
    }

    protected <T> T request(@NotNull Request request, @NotNull Converter<T, ?> converter) throws Exception {
        String response = this.executeRequest(request);
        return converter.convert(response);
    }

    @NotNull
    private HttpUrl getBaseUrl(@NotNull String pathSegment, @Nullable Map<String, String> queryParams) {
        return this.getBaseUrl(pathSegment, queryParams, Config.getBaseUrlInsurance(), Config.getInsurancePort());
    }

    @NotNull
    private HttpUrl getBaseUrl(@NotNull String pathSegment, @Nullable Map<String, String> queryParams, @NotNull String baseUrl, int port) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)baseUrl).newBuilder().addEncodedPathSegments(pathSegment);
        if (port > 0) {
            urlBuilder.port(port);
        }
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                urlBuilder.addQueryParameter(key, queryParams.get(key));
            }
        }
        return urlBuilder.build();
    }

    @NotNull
    private Request getGetRequest(@NotNull String pathSegment, @Nullable Map<String, String> queryParams) {
        HttpUrl httpUrl = this.getBaseUrl(pathSegment, queryParams);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        return requestBuilder.build();
    }

    @NotNull
    private String executeRequest(Request request) throws Exception {
        return this.httpClient.newCall(request).execute().body().string();
    }
}

