/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway;

import java.util.Collections;
import java.util.Date;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.AuthData;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.DiagnosticCardNeed;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.PaymentOrder;
import ru.tinkoff.tisdk.QuickQuoteData;
import ru.tinkoff.tisdk.SessionProvider;
import ru.tinkoff.tisdk.SravniRuCalcInfo;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.DefaultParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.builder.DetailsParamsBuilder;
import ru.tinkoff.tisdk.carreference.gateway.vehicle.converter.DetailsConverter;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.casco.CascoData;
import ru.tinkoff.tisdk.gateway.BaseGateway;
import ru.tinkoff.tisdk.gateway.Config;
import ru.tinkoff.tisdk.gateway.converter.builders.CheckUserTypeParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.CompleteDealParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.CreateCascoParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.DiagnosticCardNeedParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.EOsagoUpdateParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.PaymentOrderParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.SignInParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.SignUpParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.SimpleRateParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.SimpleUpdateParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.SmsCodeParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.SravniRuCalculationParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.builders.UpdateCascoParamsBuilder;
import ru.tinkoff.tisdk.gateway.converter.converters.AuthDataConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.CheckUserTypeConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.CompleteDealConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.CreateCascoRequestConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.DealConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.DiagnosticCardNeedConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.NearestRegionDataConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.PaymentOrderConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.PingConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.SimpleUpdateConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.SmsCodeConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.SravniRuConverter;
import ru.tinkoff.tisdk.gateway.converter.converters.UpdateCascoRequestConverter;
import ru.tinkoff.tisdk.subject.Phone;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

public class ApiGatewayImpl
extends BaseGateway
implements ApiGateway {
    private static final String BASE_URL_TCS = Config.getBaseUrlTcs();
    private static final String BASE_URL_SRAVNI = Config.getBaseUrlSravni();
    private static final String CREATE_CASCO = "v1/add_application";
    private static final String UPDATE_CASCO = "api/lead";
    private static final String PATH_THIRD_PARTY = "osago/v1.0/save-query";
    private static final String METHOD_DETAILS = "api/vehicle_search/vehicledetails";
    private static final String CHECK = "api/autosave/data";
    private static final String SIMPLE_UPDATE = "api/deal/simple_update";
    private static final String EOSAGO_UPDATE = "api/deal/eosago_update";
    private static final String EOSAGO_COMPLETE = "api/quoteSet/complete";
    private static final String PAYMENT_ORDER = "api/paycart/payment_order";
    private static final String DIAGNOSTIC_CARD = "api/diagnosticCard";
    private static final String AUTH_SMS_CODE = "api/auth/sms_code";
    private static final String AUTH_SIGN_UP = "api/auth/signup";
    private static final String AUTH_SIGN_IN = "api/auth/signin";
    private static final String AUTH_PING = "api/auth/ping";
    private static final String REGION_BY_IP = "/geo/regions/regionByIp";
    private static final String KEY_AUTHORIZATION = "Authorization";
    private static final String KEY_BEARER = "Bearer";
    private static final String SESSION_ID_PARAM = "sessionid";
    private final SessionProvider sessionProvider;

    public ApiGatewayImpl(@NotNull OkHttpClient httpClient, SessionProvider sessionProvider) {
        super(httpClient);
        this.sessionProvider = sessionProvider;
    }

    @Override
    @Nullable
    public VehicleDetails queryVehicleDetails(@NotNull String modelId, int year, @NotNull String autoboxId, @NotNull String engineId, @NotNull String gearboxId, @Nullable String region) throws Exception {
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(modelId));
        Preconditions.checkArgument(year > 0);
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(autoboxId));
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(gearboxId));
        Preconditions.checkArgument(StringUtilsKt.isNotBlank(engineId));
        return this.requestPost(METHOD_DETAILS, new DetailsParamsBuilder(modelId, year, autoboxId, engineId, gearboxId, region), new DetailsConverter());
    }

    @Override
    @NotNull
    public InsuranceRate prePricing(@NotNull QuickQuoteData data) throws Exception {
        if (data == null) {
            throw new NullPointerException();
        }
        return this.requestPost(SIMPLE_UPDATE, new SimpleRateParamsBuilder(data), new SimpleUpdateConverter());
    }

    @Override
    @NotNull
    public InsuranceRate pricing(@NotNull QuickQuoteData data, @NotNull FullQuoteData fullQuoteData) throws Exception {
        return this.requestPost(SIMPLE_UPDATE, new SimpleUpdateParamsBuilder(data, fullQuoteData, null, null, null), new SimpleUpdateConverter());
    }

    @Override
    @NotNull
    public DiagnosticCardNeed diagnosticCard(@NotNull Date effective, @NotNull Vehicle vehicle, @NotNull VehicleDocument vehicleDocument) throws Exception {
        if (effective == null) {
            throw new NullPointerException();
        }
        if (vehicle == null) {
            throw new NullPointerException();
        }
        DiagnosticCardNeedParamsBuilder builder = new DiagnosticCardNeedParamsBuilder(effective, vehicle, vehicleDocument);
        return this.requestGet(DIAGNOSTIC_CARD, builder.buildQueryParams(), new DiagnosticCardNeedConverter());
    }

    @Override
    @NotNull
    public Deal updateDeal(@NotNull String accessToken, @NotNull QuickQuoteData data, @NotNull FullQuoteData fullQuoteData, @Nullable String dealId) throws Exception {
        return this.requestPost(EOSAGO_UPDATE, new EOsagoUpdateParamsBuilder(data, fullQuoteData, dealId, Config.getMarketingSource(), Config.getMarketingChannel()), accessToken, new DealConverter(fullQuoteData));
    }

    @Override
    public boolean completeDeal(@NotNull String accessToken, @NotNull Deal deal, @NotNull FullQuoteData fullQuoteData, double kbm) throws Exception {
        return this.requestPost(EOSAGO_COMPLETE, new CompleteDealParamsBuilder(deal, fullQuoteData, kbm), accessToken, new CompleteDealConverter());
    }

    @Override
    @NotNull
    public PaymentOrder paymentOrder(@NotNull String accessToken, @NotNull Deal deal) throws Exception {
        return this.requestGet(PAYMENT_ORDER, new PaymentOrderParamsBuilder(deal).buildQueryParams(), accessToken, new PaymentOrderConverter());
    }

    @Override
    @NotNull
    public String smsCode(@NotNull Phone phone, @NotNull String deviceId) throws Exception {
        return this.requestPost(AUTH_SMS_CODE, new SmsCodeParamsBuilder(phone, deviceId), new SmsCodeConverter());
    }

    @Override
    @NotNull
    public AuthData signUp(@NotNull String accessToken, @NotNull String password) throws Exception {
        return this.requestPost(AUTH_SIGN_UP, new SignUpParamsBuilder(accessToken, password), new AuthDataConverter());
    }

    @Override
    public long ping(@NotNull String accessToken) throws Exception {
        return this.requestPost(AUTH_PING, new DefaultParamsBuilder(), accessToken, new PingConverter());
    }

    @Override
    @NotNull
    public AuthData signIn(@NotNull String refreshToken, @NotNull String deviceId) throws Exception {
        return this.requestPost(AUTH_SIGN_IN, new SignInParamsBuilder(refreshToken, deviceId), new AuthDataConverter());
    }

    @Override
    @NotNull
    public String getUserType(@NotNull FullQuoteData data, @NotNull Vehicle vehicle, @NotNull InsuranceRate insuranceRate) throws Exception {
        return this.requestPost(CHECK, new CheckUserTypeParamsBuilder(data, vehicle, insuranceRate), new CheckUserTypeConverter());
    }

    @Override
    @NotNull
    public String createCascoRequest(@NotNull CascoData data) throws Exception {
        HttpUrl httpUrl = this.getRequestUrl(CREATE_CASCO, new CreateCascoParamsBuilder(data).buildQueryParams(), BASE_URL_TCS, 0);
        String sessionId = this.sessionProvider.getSessionId();
        if (!StringUtilsKt.isEmpty(sessionId)) {
            httpUrl = httpUrl.newBuilder().addQueryParameter(SESSION_ID_PARAM, sessionId).build();
        }
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        return this.request(requestBuilder.build(), new CreateCascoRequestConverter());
    }

    @Override
    @NotNull
    public String updateCascoRequest(@NotNull CascoData data) throws Exception {
        return this.requestPost(UPDATE_CASCO, new UpdateCascoParamsBuilder(data), new UpdateCascoRequestConverter());
    }

    @Override
    @NotNull
    public SravniRuCalcInfo createSravniRuCalculation(@NotNull FullQuoteData fullQuoteData, @NotNull Vehicle vehicle) throws Exception {
        SravniRuCalculationParamsBuilder builder = new SravniRuCalculationParamsBuilder(vehicle, fullQuoteData);
        HttpUrl httpUrl = this.getRequestUrl(PATH_THIRD_PARTY, ((ParamsBuilder)builder).buildQueryParams(), BASE_URL_SRAVNI, 0);
        RequestBody requestBody = this.getRequestBody(((ParamsBuilder)builder).buildBodyParams());
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).post(requestBody);
        return this.request(requestBuilder.build(), new SravniRuConverter());
    }

    @Override
    @NotNull
    public String regionByIp() throws Exception {
        HttpUrl httpUrl = this.getRequestUrl(REGION_BY_IP, Collections.emptyMap(), BASE_URL_TCS, 0);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        return this.request(requestBuilder.build(), new NearestRegionDataConverter());
    }

    @Override
    protected void addAuthorizationHeader(@Nullable String accessToken, @NotNull Request.Builder requestBuilder) {
        if (accessToken != null) {
            requestBuilder.addHeader(KEY_AUTHORIZATION, "Bearer " + accessToken);
        }
    }
}

