/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.converters;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.Deal;
import ru.tinkoff.tisdk.DealResult;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.Converter;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.InsuranceResponse;
import ru.tinkoff.tisdk.carreference.gateway.common.convertion.ServerResponse;
import ru.tinkoff.tisdk.gateway.model.GAddress;
import ru.tinkoff.tisdk.gateway.model.GContact;
import ru.tinkoff.tisdk.gateway.model.GDealResult;
import ru.tinkoff.tisdk.gateway.model.GPassport;
import ru.tinkoff.tisdk.gateway.model.payload.EOsagoUpdatePayload;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.subject.FullDriverLicense;
import ru.tinkoff.tisdk.subject.PartialDriverLicense;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.Preconditions;
import ru.tinkoff.tisdk.utils.StringUtilsKt;

public class DealConverter
extends Converter<Deal, EOsagoUpdatePayload> {
    private final FullQuoteData fullQuoteData;

    public DealConverter(@NotNull FullQuoteData fullQuoteData) {
        this.fullQuoteData = Preconditions.checkNotNull(fullQuoteData);
    }

    @Override
    @NotNull
    protected ServerResponse<EOsagoUpdatePayload> parse(@NotNull String json) {
        return (ServerResponse)new Gson().fromJson(json, new TypeToken<InsuranceResponse<EOsagoUpdatePayload>>(){}.getType());
    }

    @Override
    @NotNull
    protected Deal convertPayload(@NotNull ServerResponse<EOsagoUpdatePayload> response) throws Exception {
        EOsagoUpdatePayload payload = Preconditions.checkNotNull(response.getPayload());
        int insurerNumber = payload.Deal.InsurerNumber;
        int ownerNumber = payload.Deal.VehicleOwnerNumber;
        for (GContact contact : payload.Deal.Contacts) {
            if (contact.SubjectNumber == insurerNumber) {
                this.copyData(this.fullQuoteData.getInsurer(), contact);
                continue;
            }
            if (contact.SubjectNumber == ownerNumber) {
                this.copyData(this.fullQuoteData.getOwner(), contact);
                continue;
            }
            if (this.fullQuoteData.getDrivers().getDrivers() == null) continue;
            for (final Driver driver : this.fullQuoteData.getDrivers().getDrivers()) {
                if (!this.checkSamePerson(driver, contact)) continue;
                this.copyData(driver, contact, new DriverLicenseConverter<FullDriverLicense>(){

                    @Override
                    @NotNull
                    public FullDriverLicense convert(@NotNull GPassport passport) throws Exception {
                        return (FullDriverLicense)driver.getDriverLicense();
                    }
                });
            }
        }
        return new Deal(payload.Deal.Id, payload.Deal.SetDetails.SetNumber, this.convertResult(payload.Deal.SetDetails.OsagoQuote.Result), payload.IsRequiredDocumentsScan, payload.Deal.SetDetails.OsagoQuote.QuoteNumber);
    }

    private DealResult convertResult(@NotNull GDealResult result) {
        return new DealResult(result.PolicyStatus, result.TotalPremium);
    }

    private <T extends PartialDriverLicense> void copyData(@NotNull Subject<T, ?> subject, @NotNull GContact contact, @NotNull DriverLicenseConverter<T> licenseConverter) throws Exception {
        subject.setId(contact.PublicId);
        if (contact.Passports != null) {
            for (GPassport passport : contact.Passports) {
                if (!"\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B".equals(passport.DocumentType)) continue;
                T driverLicense = licenseConverter.convert(passport);
                ((PartialDriverLicense)driverLicense).setId(passport.DocumentId);
                subject.setDriverLicense(driverLicense);
                break;
            }
        }
    }

    private void copyData(@NotNull Contact contact1, @NotNull GContact contact2) throws Exception {
        this.copyData(contact1, contact2, new DriverLicenseConverter<PartialDriverLicense>(){

            @Override
            @NotNull
            public PartialDriverLicense convert(@NotNull GPassport passport) throws Exception {
                return new PartialDriverLicense(passport.Series, passport.Number, DateUtils.parseDate(passport.DateIssue));
            }
        });
        if (contact2.Passports != null) {
            for (GPassport passport : contact2.Passports) {
                if (!"\u041f\u0430\u0441\u043f\u043e\u0440\u0442 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0438\u043d\u0430 \u0420\u0424".equals(passport.DocumentType)) continue;
                contact1.getPassport().setId(passport.DocumentId);
                break;
            }
        }
        if (contact2.Addresses != null) {
            block9: for (GAddress address : contact2.Addresses) {
                switch (address.AddressType) {
                    case "\u0410\u0434\u0440\u0435\u0441 \u0444\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0440\u043e\u0436\u0438\u0432\u0430\u043d\u0438\u044f": {
                        contact1.getHomeAddress().setId(address.AddressId);
                        continue block9;
                    }
                    case "\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438": {
                        contact1.getRegisteredAddress().setId(address.AddressId);
                    }
                }
            }
        }
    }

    private boolean checkSamePerson(@NotNull Driver driver1, @NotNull GContact driver2) {
        GPassport license = null;
        if (driver2.Passports != null) {
            for (GPassport passport : driver2.Passports) {
                if (!"\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0443\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u0435\u043d\u0438\u0435 \u0420\u0424 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 B".equals(passport.DocumentType)) continue;
                license = passport;
                break;
            }
        }
        return license != null && StringUtilsKt.equals(((FullDriverLicense)driver1.getDriverLicense()).getSeries(), license.Series) && StringUtilsKt.equals(((FullDriverLicense)driver1.getDriverLicense()).getNumber(), license.Number) && StringUtilsKt.equals(driver1.getFirstName(), driver2.FirstName) && StringUtilsKt.equals(driver1.getLastName(), driver2.LastName) && StringUtilsKt.equals(driver1.getMiddleName(), driver2.MiddleName);
    }

    private static abstract class DriverLicenseConverter<T extends PartialDriverLicense> {
        private DriverLicenseConverter() {
        }

        @NotNull
        public abstract T convert(@NotNull GPassport var1) throws Exception;
    }
}

