/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.vehicle;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.utils.StringUtilsKt;
import ru.tinkoff.tisdk.vehicle.VehicleDocument$TypeDocument$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0002&'BA\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006("}, d2={"Lru/tinkoff/tisdk/vehicle/VehicleDocument;", "Ljava/io/Serializable;", "licensePlate", "", "vin", "typeDocument", "Lru/tinkoff/tisdk/vehicle/VehicleDocument$TypeDocument;", "seriesNumber", "issueDate", "Ljava/util/Date;", "(Ljava/lang/String;Ljava/lang/String;Lru/tinkoff/tisdk/vehicle/VehicleDocument$TypeDocument;Ljava/lang/String;Ljava/util/Date;)V", "isValid", "", "()Z", "getIssueDate", "()Ljava/util/Date;", "getLicensePlate", "()Ljava/lang/String;", "number", "getNumber", "series", "getSeries", "getSeriesNumber", "getTypeDocument", "()Lru/tinkoff/tisdk/vehicle/VehicleDocument$TypeDocument;", "getVin", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "TypeDocument", "tisdk-domain"})
public final class VehicleDocument
implements Serializable {
    @Nullable
    private final String licensePlate;
    @Nullable
    private final String vin;
    @Nullable
    private final TypeDocument typeDocument;
    @Nullable
    private final String seriesNumber;
    @Nullable
    private final Date issueDate;
    private static final String REG_EXP_LICENSE_PLATE = "^[\u0410\u0412\u0415\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u0425]\\d{3}[\u0410\u0412\u0415\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u0425]{2}\\d{2,3}$";
    private static final String REG_EXP_VIN = "^[0123456789ABCDEFGHJKLMNPRSTUVWXYZ]{17}$";
    private static final String REG_EXP_SERIES_AND_NUMBER = "^\\d{2}[\u0410-\u042f0-9]{2}\\d{6}$";
    private static final int SERIES_LEN = 4;
    private static final int NUMBER_LEN = 6;
    private static final String TYPE_STS = "31";
    private static final String TYPE_PTS = "30";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getSeries() {
        String string;
        String string2 = this.seriesNumber;
        if (string2 != null) {
            String string3 = string2;
            int n = 0;
            int n2 = 4;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getNumber() {
        String string;
        String string2 = this.seriesNumber;
        if (string2 != null) {
            String string3 = string2;
            int n = this.seriesNumber.length() - 6;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        return string;
    }

    public final boolean isValid() {
        return Companion.validateVin(this.vin) && Companion.validateLicensePlate(this.licensePlate, this.typeDocument) && Companion.validateSeriesNumber(this.seriesNumber) && Companion.validateIssue(this.issueDate, 0);
    }

    @Nullable
    public final String getLicensePlate() {
        return this.licensePlate;
    }

    @Nullable
    public final String getVin() {
        return this.vin;
    }

    @Nullable
    public final TypeDocument getTypeDocument() {
        return this.typeDocument;
    }

    @Nullable
    public final String getSeriesNumber() {
        return this.seriesNumber;
    }

    @Nullable
    public final Date getIssueDate() {
        return this.issueDate;
    }

    public VehicleDocument(@Nullable String licensePlate, @Nullable String vin, @Nullable TypeDocument typeDocument, @Nullable String seriesNumber, @Nullable Date issueDate) {
        this.licensePlate = licensePlate;
        this.vin = vin;
        this.typeDocument = typeDocument;
        this.seriesNumber = seriesNumber;
        this.issueDate = issueDate;
    }

    public /* synthetic */ VehicleDocument(String string, String string2, TypeDocument typeDocument, String string3, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            typeDocument = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            date = null;
        }
        this(string, string2, typeDocument, string3, date);
    }

    public VehicleDocument() {
        this(null, null, null, null, null, 31, null);
    }

    @Nullable
    public final String component1() {
        return this.licensePlate;
    }

    @Nullable
    public final String component2() {
        return this.vin;
    }

    @Nullable
    public final TypeDocument component3() {
        return this.typeDocument;
    }

    @Nullable
    public final String component4() {
        return this.seriesNumber;
    }

    @Nullable
    public final Date component5() {
        return this.issueDate;
    }

    @NotNull
    public final VehicleDocument copy(@Nullable String licensePlate, @Nullable String vin, @Nullable TypeDocument typeDocument, @Nullable String seriesNumber, @Nullable Date issueDate) {
        return new VehicleDocument(licensePlate, vin, typeDocument, seriesNumber, issueDate);
    }

    @NotNull
    public static /* synthetic */ VehicleDocument copy$default(VehicleDocument vehicleDocument, String string, String string2, TypeDocument typeDocument, String string3, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            string = vehicleDocument.licensePlate;
        }
        if ((n & 2) != 0) {
            string2 = vehicleDocument.vin;
        }
        if ((n & 4) != 0) {
            typeDocument = vehicleDocument.typeDocument;
        }
        if ((n & 8) != 0) {
            string3 = vehicleDocument.seriesNumber;
        }
        if ((n & 0x10) != 0) {
            date = vehicleDocument.issueDate;
        }
        return vehicleDocument.copy(string, string2, typeDocument, string3, date);
    }

    @NotNull
    public String toString() {
        return "VehicleDocument(licensePlate=" + this.licensePlate + ", vin=" + this.vin + ", typeDocument=" + (Object)((Object)this.typeDocument) + ", seriesNumber=" + this.seriesNumber + ", issueDate=" + this.issueDate + ")";
    }

    public int hashCode() {
        String string = this.licensePlate;
        String string2 = this.vin;
        TypeDocument typeDocument = this.typeDocument;
        String string3 = this.seriesNumber;
        Date date = this.issueDate;
        return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (typeDocument != null ? ((Object)((Object)typeDocument)).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (date != null ? ((Object)date).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof VehicleDocument)) break block3;
                VehicleDocument vehicleDocument = (VehicleDocument)object;
                if (!Intrinsics.areEqual((Object)this.licensePlate, (Object)vehicleDocument.licensePlate) || !Intrinsics.areEqual((Object)this.vin, (Object)vehicleDocument.vin) || !Intrinsics.areEqual((Object)((Object)this.typeDocument), (Object)((Object)vehicleDocument.typeDocument)) || !Intrinsics.areEqual((Object)this.seriesNumber, (Object)vehicleDocument.seriesNumber) || !Intrinsics.areEqual((Object)this.issueDate, (Object)vehicleDocument.issueDate)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/tinkoff/tisdk/vehicle/VehicleDocument$TypeDocument;", "", "(Ljava/lang/String;I)V", "toString", "", "STS", "PTS", "tisdk-domain"})
    public static final class TypeDocument
    extends Enum<TypeDocument> {
        public static final /* enum */ TypeDocument STS;
        public static final /* enum */ TypeDocument PTS;
        private static final /* synthetic */ TypeDocument[] $VALUES;

        static {
            TypeDocument[] typeDocumentArray = new TypeDocument[2];
            TypeDocument[] typeDocumentArray2 = typeDocumentArray;
            typeDocumentArray[0] = STS = new TypeDocument();
            typeDocumentArray[1] = PTS = new TypeDocument();
            $VALUES = typeDocumentArray;
        }

        @NotNull
        public String toString() {
            String string;
            switch (VehicleDocument$TypeDocument$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = VehicleDocument.TYPE_PTS;
                    break;
                }
                case 2: {
                    string = VehicleDocument.TYPE_STS;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public static TypeDocument[] values() {
            return (TypeDocument[])$VALUES.clone();
        }

        public static TypeDocument valueOf(String string) {
            return Enum.valueOf(TypeDocument.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u001a\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0017\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lru/tinkoff/tisdk/vehicle/VehicleDocument$Companion;", "", "()V", "NUMBER_LEN", "", "REG_EXP_LICENSE_PLATE", "", "REG_EXP_SERIES_AND_NUMBER", "REG_EXP_VIN", "SERIES_LEN", "TYPE_PTS", "TYPE_STS", "validateIssue", "", "issueDate", "Ljava/util/Date;", "vehicleYear", "validateLicensePlate", "licensePlate", "typeDocument", "Lru/tinkoff/tisdk/vehicle/VehicleDocument$TypeDocument;", "validateSeriesNumber", "seriesNumber", "validateTypeDocument", "validateVin", "vin", "tisdk-domain"})
    public static final class Companion {
        public final boolean validateLicensePlate(@Nullable String licensePlate, @Nullable TypeDocument typeDocument) {
            if (typeDocument == TypeDocument.PTS && StringUtilsKt.isEmpty(licensePlate)) {
                return true;
            }
            if (StringUtilsKt.isEmpty(licensePlate)) {
                return false;
            }
            Pattern pattern = Pattern.compile(VehicleDocument.REG_EXP_LICENSE_PLATE);
            String string = licensePlate;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }

        public final boolean validateVin(@Nullable String vin) {
            if (StringUtilsKt.isEmpty(vin)) {
                return false;
            }
            Matcher matcher = Pattern.compile(VehicleDocument.REG_EXP_VIN).matcher(vin);
            return matcher.matches();
        }

        public final boolean validateTypeDocument(@Nullable TypeDocument typeDocument) {
            return typeDocument != null;
        }

        public final boolean validateSeriesNumber(@Nullable String seriesNumber) {
            if (StringUtilsKt.isEmpty(seriesNumber)) {
                return false;
            }
            Matcher matcher = Pattern.compile(VehicleDocument.REG_EXP_SERIES_AND_NUMBER).matcher(seriesNumber);
            return matcher.matches();
        }

        public final boolean validateIssue(@Nullable Date issueDate, int vehicleYear) {
            return issueDate == null ? false : issueDate.compareTo(new Date()) <= 0 && DateUtils.getYear(issueDate) >= vehicleYear;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

