/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.BuyingCascoProcess;
import ru.tinkoff.tisdk.BuyingProcess;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.casco.CascoContact;
import ru.tinkoff.tisdk.casco.CascoData;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lru/tinkoff/tisdk/BuyingCascoProcessImpl;", "Lru/tinkoff/tisdk/BuyingProcess;", "Lru/tinkoff/tisdk/BuyingCascoProcess;", "apiGateway", "Lru/tinkoff/tisdk/ApiGateway;", "(Lru/tinkoff/tisdk/ApiGateway;)V", "<set-?>", "Lru/tinkoff/tisdk/casco/CascoData;", "cascoData", "getCascoData", "()Lru/tinkoff/tisdk/casco/CascoData;", "applyInitialCascoData", "", "getOrCreateRequestId", "", "existingCascoData", "newData", "resetCasco", "sendCascoRequest", "tisdk-domain"})
public final class BuyingCascoProcessImpl
extends BuyingProcess
implements BuyingCascoProcess {
    @Nullable
    private CascoData cascoData;

    @Override
    @Nullable
    public CascoData getCascoData() {
        return this.cascoData;
    }

    @Override
    public void applyInitialCascoData(@Nullable CascoData cascoData) {
        boolean bl = this.getCascoData() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Casco already initialized";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.cascoData = cascoData;
    }

    @Override
    public void sendCascoRequest(@NotNull CascoData newData) {
        Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
        boolean bl = newData.isValidExceptDetails();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String id = this.getOrCreateRequestId(this.getCascoData(), newData);
        CharSequence charSequence = id;
        bl3 = false;
        boolean bl6 = charSequence.length() > 0;
        bl3 = false;
        bl4 = false;
        bl4 = false;
        boolean bl7 = false;
        if (!bl6) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        newData.setRequestId(id);
        Vehicle vehicle = newData.getVehicle();
        if (vehicle == null) {
            Intrinsics.throwNpe();
        }
        Address address = newData.getCity();
        if (address == null) {
            Intrinsics.throwNpe();
        }
        this.updateVehicleDetailsIfNeeded(vehicle, address);
        bl6 = newData.isValid();
        bl3 = false;
        bl4 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string = "Unable to complete casco request without VehicleDetails data";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.cascoData = newData;
        String string = this.getApiGateway().updateCascoRequest(newData);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiGateway.updateCascoRequest(newData)");
        String newId = string;
        bl3 = Intrinsics.areEqual((Object)id, (Object)newId);
        bl4 = false;
        bl7 = false;
        if (!bl3) {
            boolean bl10 = false;
            String string2 = "Casco application id is invalid: " + newId;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getOrCreateRequestId(CascoData existingCascoData, CascoData newData) {
        CharSequence charSequence;
        if (existingCascoData != null) {
            CharSequence charSequence2 = existingCascoData.getRequestId();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                CascoContact cascoContact2 = existingCascoData.getContact();
                cascoContact2 = newData.getContact();
                if (Intrinsics.areEqual((Object)(cascoContact != null ? cascoContact.getPhone() : null), (Object)(cascoContact2 != null ? cascoContact2.getPhone() : null))) {
                    charSequence2 = existingCascoData.getRequestId();
                    bl = false;
                    bl2 = false;
                    bl2 = false;
                    boolean bl3 = false;
                    if (charSequence2 == null) {
                        boolean bl4 = false;
                        String string = "Required value was null.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    charSequence = charSequence2;
                    return charSequence;
                }
            }
        }
        String string = this.getApiGateway().createCascoRequest(newData);
        charSequence = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiGateway.createCascoRequest(newData)");
        return charSequence;
    }

    @Override
    public void resetCasco() {
        this.cascoData = null;
    }

    public BuyingCascoProcessImpl(@NotNull ApiGateway apiGateway) {
        Intrinsics.checkParameterIsNotNull((Object)apiGateway, (String)"apiGateway");
        super(apiGateway);
    }
}

