/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.tisdk.ApiGateway;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.PrePriceUseCase;
import ru.tinkoff.tisdk.QuickQuoteData;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.carreference.model.VehicleProperties;
import ru.tinkoff.tisdk.carreference.model.VehicleProperty;
import ru.tinkoff.tisdk.carreference.model.Year;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH\u0002J\u001a\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/tinkoff/tisdk/PrePriceUseCaseImpl;", "Lru/tinkoff/tisdk/PrePriceUseCase;", "apiGateway", "Lru/tinkoff/tisdk/ApiGateway;", "(Lru/tinkoff/tisdk/ApiGateway;)V", "calculatePrice", "Lru/tinkoff/tisdk/InsuranceRate;", "data", "Lru/tinkoff/tisdk/QuickQuoteData;", "qqData", "fqData", "Lru/tinkoff/tisdk/FullQuoteData;", "vehicle", "Lru/tinkoff/tisdk/Vehicle;", "isVehicleDetailsUpdateRequired", "", "updateQQVehicleIfNeeded", "", "updateVehicleDetailsIfPossible", "address", "Lru/tinkoff/tisdk/address/Address;", "tisdk-domain"})
public final class PrePriceUseCaseImpl
implements PrePriceUseCase {
    private final ApiGateway apiGateway;

    @Override
    @NotNull
    public InsuranceRate calculatePrice(@NotNull Vehicle vehicle) {
        Intrinsics.checkParameterIsNotNull((Object)vehicle, (String)"vehicle");
        return this.calculatePrice(new QuickQuoteData(null, vehicle, 1, null));
    }

    @Override
    @NotNull
    public InsuranceRate calculatePrice(@NotNull QuickQuoteData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.updateQQVehicleIfNeeded(data);
        InsuranceRate insuranceRate = this.apiGateway.prePricing(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)insuranceRate, (String)"apiGateway.prePricing(data)");
        return insuranceRate;
    }

    @Override
    @NotNull
    public InsuranceRate calculatePrice(@NotNull QuickQuoteData qqData, @NotNull FullQuoteData fqData) {
        Intrinsics.checkParameterIsNotNull((Object)qqData, (String)"qqData");
        Intrinsics.checkParameterIsNotNull((Object)fqData, (String)"fqData");
        this.updateQQVehicleIfNeeded(qqData);
        InsuranceRate insuranceRate = this.apiGateway.pricing(qqData, fqData);
        Intrinsics.checkExpressionValueIsNotNull((Object)insuranceRate, (String)"apiGateway.pricing(qqData, fqData)");
        return insuranceRate;
    }

    private final void updateQQVehicleIfNeeded(QuickQuoteData qqData) {
        Vehicle vehicle = qqData.getVehicle();
        Serializable serializable = vehicle;
        if ((serializable != null && (serializable = ((Vehicle)serializable).getProperties()) != null ? ((VehicleProperties)serializable).getMaker() : null) == null || vehicle.getProperties().getModel() == null) {
            throw (Throwable)new IllegalStateException("Vehicle should be provided with maker and model to calculate an insurance price.");
        }
        if (this.isVehicleDetailsUpdateRequired(vehicle)) {
            this.updateVehicleDetailsIfPossible(vehicle, qqData.getCity());
        }
    }

    private final boolean isVehicleDetailsUpdateRequired(Vehicle vehicle) {
        VehicleDetails vehicleDetails = vehicle.getDetails();
        if (vehicleDetails == null) {
            return true;
        }
        VehicleDetails details = vehicleDetails;
        return details.getPrice() <= 0.0 || StringsKt.isBlank((CharSequence)details.getVehicleId()) || StringsKt.isBlank((CharSequence)details.getGroupId());
    }

    private final void updateVehicleDetailsIfPossible(Vehicle vehicle, Address address) {
        Serializable serializable;
        Object modelId;
        VehicleProperties properties;
        block8: {
            block7: {
                properties = vehicle.getProperties();
                Object object = properties.getModel();
                if (object == null || (object = ((VehicleProperty)object).getId()) == null) {
                    return;
                }
                modelId = object;
                serializable = properties.getYear();
                if (serializable == null) break block7;
                Integer n = ((Year)serializable).getIntValue();
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                serializable = it > 1900 ? n : null;
                if (serializable != null) break block8;
            }
            return;
        }
        int year = (Integer)serializable;
        Object object = properties.getAutobox();
        if (object == null || (object = ((VehicleProperty)object).getId()) == null) {
            return;
        }
        Object autoboxId = object;
        Object object2 = properties.getEngine();
        if (object2 == null || (object2 = ((VehicleProperty)object2).getId()) == null) {
            return;
        }
        Object engineId = object2;
        Object object3 = properties.getGearbox();
        if (object3 == null || (object3 = ((VehicleProperty)object3).getId()) == null) {
            return;
        }
        Object gearboxId = object3;
        Address address2 = address;
        String region = address2 != null ? address2.getRegion() : null;
        vehicle.setDetails(this.apiGateway.queryVehicleDetails((String)modelId, year, (String)autoboxId, (String)engineId, (String)gearboxId, region));
    }

    public PrePriceUseCaseImpl(@NotNull ApiGateway apiGateway) {
        Intrinsics.checkParameterIsNotNull((Object)apiGateway, (String)"apiGateway");
        this.apiGateway = apiGateway;
    }
}

