/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.tisdk.gateway.converter.builders;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.tisdk.FullQuoteData;
import ru.tinkoff.tisdk.InsuranceConditions;
import ru.tinkoff.tisdk.InsuranceRate;
import ru.tinkoff.tisdk.QuickQuoteData;
import ru.tinkoff.tisdk.Vehicle;
import ru.tinkoff.tisdk.address.Address;
import ru.tinkoff.tisdk.carreference.gateway.common.ParamsBuilder;
import ru.tinkoff.tisdk.carreference.model.VehicleDetails;
import ru.tinkoff.tisdk.carreference.model.Year;
import ru.tinkoff.tisdk.gateway.model.GAddress;
import ru.tinkoff.tisdk.gateway.model.GContact;
import ru.tinkoff.tisdk.gateway.model.GDriver;
import ru.tinkoff.tisdk.gateway.model.GDrivers;
import ru.tinkoff.tisdk.gateway.model.GMultidrive;
import ru.tinkoff.tisdk.gateway.model.GNamedDrivers;
import ru.tinkoff.tisdk.gateway.model.GPhone;
import ru.tinkoff.tisdk.gateway.model.GPriceModel;
import ru.tinkoff.tisdk.gateway.model.GQuote;
import ru.tinkoff.tisdk.gateway.model.GSetDetails;
import ru.tinkoff.tisdk.gateway.model.GTechInspectionInfo;
import ru.tinkoff.tisdk.gateway.model.GVehicle;
import ru.tinkoff.tisdk.gateway.model.GVehicleDocument;
import ru.tinkoff.tisdk.gateway.model.GVehicleLegalInfo;
import ru.tinkoff.tisdk.gateway.model.GVehicleReferenceDetails;
import ru.tinkoff.tisdk.subject.Contact;
import ru.tinkoff.tisdk.subject.Driver;
import ru.tinkoff.tisdk.subject.Drivers;
import ru.tinkoff.tisdk.subject.FullDriverLicense;
import ru.tinkoff.tisdk.subject.Insurer;
import ru.tinkoff.tisdk.subject.Passport;
import ru.tinkoff.tisdk.subject.Phone;
import ru.tinkoff.tisdk.subject.Subject;
import ru.tinkoff.tisdk.utils.DateUtils;
import ru.tinkoff.tisdk.vehicle.VehicleDocument;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0016\u0018\u0000 L2\u00020\u0001:\u0001LB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010/\u001a\u00020\u0007H\u0016J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000701H\u0016J \u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000307H\u0002J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001b\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u00104\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u0002052\u0006\u00104\u001a\u00020$H\u0002J\u0018\u0010<\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u0002052\u0006\u0010?\u001a\u00020@H\u0002J\b\u0010B\u001a\u00020CH\u0002J\u001b\u0010D\u001a\b\u0012\u0004\u0012\u00020E092\u0006\u00104\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010FJ\u0018\u0010G\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000307H\u0002J\u001e\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002050K2\u0006\u0010?\u001a\u00020@H\u0002R\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006M"}, d2={"Lru/tinkoff/tisdk/gateway/converter/builders/PriceParamsBuilder;", "Lru/tinkoff/tisdk/carreference/gateway/common/ParamsBuilder;", "data", "Lru/tinkoff/tisdk/QuickQuoteData;", "fullQuoteData", "Lru/tinkoff/tisdk/FullQuoteData;", "dealId", "", "marketingSource", "marketingChannel", "insuranceRate", "Lru/tinkoff/tisdk/InsuranceRate;", "(Lru/tinkoff/tisdk/QuickQuoteData;Lru/tinkoff/tisdk/FullQuoteData;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lru/tinkoff/tisdk/InsuranceRate;)V", "conditions", "Lru/tinkoff/tisdk/InsuranceConditions;", "getConditions", "()Lru/tinkoff/tisdk/InsuranceConditions;", "setConditions", "(Lru/tinkoff/tisdk/InsuranceConditions;)V", "getData", "()Lru/tinkoff/tisdk/QuickQuoteData;", "setData", "(Lru/tinkoff/tisdk/QuickQuoteData;)V", "drivers", "Lru/tinkoff/tisdk/subject/Drivers;", "getDrivers", "()Lru/tinkoff/tisdk/subject/Drivers;", "setDrivers", "(Lru/tinkoff/tisdk/subject/Drivers;)V", "insurer", "Lru/tinkoff/tisdk/subject/Insurer;", "getInsurer", "()Lru/tinkoff/tisdk/subject/Insurer;", "setInsurer", "(Lru/tinkoff/tisdk/subject/Insurer;)V", "owner", "Lru/tinkoff/tisdk/subject/Contact;", "getOwner", "()Lru/tinkoff/tisdk/subject/Contact;", "setOwner", "(Lru/tinkoff/tisdk/subject/Contact;)V", "vehicleDocument", "Lru/tinkoff/tisdk/vehicle/VehicleDocument;", "getVehicleDocument", "()Lru/tinkoff/tisdk/vehicle/VehicleDocument;", "setVehicleDocument", "(Lru/tinkoff/tisdk/vehicle/VehicleDocument;)V", "buildBodyParams", "buildQueryParams", "", "checkSamePerson", "", "contact", "Lru/tinkoff/tisdk/gateway/model/GContact;", "subject", "Lru/tinkoff/tisdk/subject/Subject;", "createAddresses", "", "Lru/tinkoff/tisdk/gateway/model/GAddress;", "(Lru/tinkoff/tisdk/subject/Contact;)[Lru/tinkoff/tisdk/gateway/model/GAddress;", "createContact", "createDriver", "Lru/tinkoff/tisdk/gateway/model/GDriver;", "driver", "Lru/tinkoff/tisdk/subject/Driver;", "createDriverContact", "createLegalInfo", "Lru/tinkoff/tisdk/gateway/model/GVehicleLegalInfo;", "createPassports", "Lru/tinkoff/tisdk/gateway/model/GVehicleDocument;", "(Lru/tinkoff/tisdk/subject/Contact;)[Lru/tinkoff/tisdk/gateway/model/GVehicleDocument;", "createSubject", "mergeDriver", "", "contacts", "", "Companion", "tisdk-domain"})
public class PriceParamsBuilder
extends ParamsBuilder {
    @NotNull
    private VehicleDocument vehicleDocument;
    @NotNull
    private Insurer insurer;
    @NotNull
    private Contact owner;
    @NotNull
    private Drivers drivers;
    @NotNull
    private InsuranceConditions conditions;
    private final String dealId;
    private final String marketingSource;
    private final String marketingChannel;
    @NotNull
    private QuickQuoteData data;
    private final InsuranceRate insuranceRate;
    private static final String KEY_RATE_ONLY = "rateOnly";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final VehicleDocument getVehicleDocument() {
        return this.vehicleDocument;
    }

    protected final void setVehicleDocument(@NotNull VehicleDocument vehicleDocument) {
        Intrinsics.checkParameterIsNotNull((Object)vehicleDocument, (String)"<set-?>");
        this.vehicleDocument = vehicleDocument;
    }

    @NotNull
    protected final Insurer getInsurer() {
        return this.insurer;
    }

    protected final void setInsurer(@NotNull Insurer insurer) {
        Intrinsics.checkParameterIsNotNull((Object)insurer, (String)"<set-?>");
        this.insurer = insurer;
    }

    @NotNull
    protected final Contact getOwner() {
        return this.owner;
    }

    protected final void setOwner(@NotNull Contact contact) {
        Intrinsics.checkParameterIsNotNull((Object)contact, (String)"<set-?>");
        this.owner = contact;
    }

    @NotNull
    protected final Drivers getDrivers() {
        return this.drivers;
    }

    protected final void setDrivers(@NotNull Drivers drivers) {
        Intrinsics.checkParameterIsNotNull((Object)drivers, (String)"<set-?>");
        this.drivers = drivers;
    }

    @NotNull
    protected final InsuranceConditions getConditions() {
        return this.conditions;
    }

    protected final void setConditions(@NotNull InsuranceConditions insuranceConditions) {
        Intrinsics.checkParameterIsNotNull((Object)insuranceConditions, (String)"<set-?>");
        this.conditions = insuranceConditions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String buildBodyParams() {
        void $this$toTypedArray$iv;
        Collection<GDriver> driversList;
        GDrivers gDrivers;
        List contacts = new ArrayList();
        contacts.add(this.createContact(this.insurer, this.conditions));
        if (this.checkSamePerson(this.owner, this.insurer)) {
            this.owner.setSubjectNumber(this.insurer.getSubjectNumber());
        } else {
            contacts.add(this.createContact(this.owner));
        }
        GDrivers gatewayDrivers = null;
        if (this.drivers.isMultiple()) {
            gDrivers = new GMultidrive();
        } else {
            driversList = new ArrayList();
            if (this.drivers.getDrivers() != null) {
                Driver[] driverArray = this.drivers.getDrivers();
                if (driverArray == null) {
                    Intrinsics.throwNpe();
                }
                for (Driver driver : driverArray) {
                    this.mergeDriver(contacts, driver);
                    driversList.add(this.createDriver(driver));
                }
            }
            Collection $this$toTypedArray$iv2 = driversList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv2;
            GDriver[] gDriverArray = thisCollection$iv.toArray(new GDriver[0]);
            if (gDriverArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            GDriver[] gDriverArray2 = gDriverArray;
            GDriver[] gDriverArray3 = Arrays.copyOf(gDriverArray2, gDriverArray2.length);
            gDrivers = new GNamedDrivers(gDriverArray3);
        }
        gatewayDrivers = gDrivers;
        driversList = contacts;
        Gson gson = new Gson();
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        GContact[] gContactArray = thisCollection$iv.toArray(new GContact[0]);
        if (gContactArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        GContact[] gContactArray2 = gContactArray;
        Integer n = this.insurer.getSubjectNumber();
        Integer n2 = this.owner.getSubjectNumber();
        Date date = this.conditions.getEffectiveDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        String string = DateUtils.formatDate(date);
        Date date2 = this.conditions.getExpirationDate();
        if (date2 == null) {
            Intrinsics.throwNpe();
        }
        GSetDetails gSetDetails = new GSetDetails(new GQuote(gatewayDrivers, string, DateUtils.formatDate(date2), this.insurer.getSubjectNumber(), this.owner.getSubjectNumber(), this.marketingSource, this.marketingChannel));
        Vehicle vehicle = this.data.getVehicle();
        if (vehicle == null) {
            Intrinsics.throwNpe();
        }
        VehicleDetails vehicleDetails = vehicle.getDetails();
        if (vehicleDetails == null) {
            Intrinsics.throwNpe();
        }
        InsuranceRate insuranceRate = this.insuranceRate;
        String string2 = insuranceRate != null ? insuranceRate.getLeadId() : null;
        GVehicle gVehicle = new GVehicle(vehicleDetails.getVehicleId(), new GVehicleReferenceDetails(this.data.getVehicle()), this.createLegalInfo());
        GSetDetails gSetDetails2 = gSetDetails;
        Integer n3 = n2;
        Integer n4 = n;
        GContact[] gContactArray3 = gContactArray2;
        String string3 = gson.toJson((Object)new GPriceModel(gContactArray3, n4, n3, gSetDetails2, gVehicle, string2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Gson().toJson(\n         \u2026              )\n        )");
        return string3;
    }

    @Override
    @NotNull
    public Map<String, String> buildQueryParams() throws Exception {
        Map<String, String> map = super.buildQueryParams();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"super.buildQueryParams()");
        Map<String, String> params = map;
        params.put(KEY_RATE_ONLY, String.valueOf(true));
        return params;
    }

    private final void mergeDriver(List<GContact> contacts, Driver driver) {
        boolean added = false;
        for (GContact contact : contacts) {
            if (!this.checkSamePerson(contact, driver)) continue;
            List vehicleDocument = new ArrayList();
            boolean licenseAdded = false;
            GVehicleDocument[] contactDocuments = contact.getDocuments();
            if (contactDocuments != null) {
                block9: for (GVehicleDocument gVehicleDocument : contactDocuments) {
                    String string;
                    if (gVehicleDocument.getType() == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1281421362: {
                            if (!string.equals("Passport")) break;
                            n = 1;
                            break;
                        }
                        case 517140122: {
                            if (!string.equals("DrivingLicense")) break;
                            n = 2;
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            vehicleDocument.add(gVehicleDocument);
                            continue block9;
                        }
                        case 2: {
                            Object DriverLicenseType = driver.getDriverLicense();
                            if (DriverLicenseType == null) {
                                Intrinsics.throwNpe();
                            }
                            String string2 = ((FullDriverLicense)DriverLicenseType).getSeries();
                            Object DriverLicenseType2 = driver.getDriverLicense();
                            if (DriverLicenseType2 == null) {
                                Intrinsics.throwNpe();
                            }
                            String string3 = ((FullDriverLicense)DriverLicenseType2).getNumber();
                            Object DriverLicenseType3 = driver.getDriverLicense();
                            if (DriverLicenseType3 == null) {
                                Intrinsics.throwNpe();
                            }
                            Date date = ((FullDriverLicense)DriverLicenseType3).getIssueDate();
                            if (date == null) {
                                Intrinsics.throwNpe();
                            }
                            vehicleDocument.add(new GVehicleDocument("DrivingLicense", string2, string3, DateUtils.formatDate(date), false, 16, null));
                            licenseAdded = true;
                        }
                    }
                }
            }
            if (!licenseAdded) {
                Object DriverLicenseType = driver.getDriverLicense();
                if (DriverLicenseType == null) {
                    Intrinsics.throwNpe();
                }
                String string = ((FullDriverLicense)DriverLicenseType).getSeries();
                Object DriverLicenseType4 = driver.getDriverLicense();
                if (DriverLicenseType4 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = ((FullDriverLicense)DriverLicenseType4).getNumber();
                Object DriverLicenseType5 = driver.getDriverLicense();
                if (DriverLicenseType5 == null) {
                    Intrinsics.throwNpe();
                }
                Date date = ((FullDriverLicense)DriverLicenseType5).getIssueDate();
                if (date == null) {
                    Intrinsics.throwNpe();
                }
                vehicleDocument.add(new GVehicleDocument("DrivingLicense", string, string4, DateUtils.formatDate(date), false, 16, null));
            }
            Object DriverLicenseType = driver.getDriverLicense();
            if (DriverLicenseType == null) {
                Intrinsics.throwNpe();
            }
            Date date = ((FullDriverLicense)DriverLicenseType).getFirstYearIssueDate();
            if (date == null) {
                Intrinsics.throwNpe();
            }
            contact.setDateOfFIDL(DateUtils.formatDate(date));
            Collection collection = vehicleDocument;
            GContact gContact = contact;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = collection;
            GVehicleDocument[] gVehicleDocumentArray = thisCollection$iv.toArray(new GVehicleDocument[0]);
            if (gVehicleDocumentArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            GVehicleDocument[] gVehicleDocumentArray2 = gVehicleDocumentArray;
            gContact.setDocuments(gVehicleDocumentArray2);
            driver.setSubjectNumber(contact.getSubjectNumber());
            added = true;
            break;
        }
        if (!added) {
            contacts.add(this.createDriverContact(driver));
        }
    }

    private final GContact createContact(Insurer insurer, InsuranceConditions conditions) {
        GPhone gPhone;
        GContact gContact = this.createContact(insurer);
        boolean bl = false;
        boolean bl2 = false;
        GContact $this$apply = gContact;
        boolean bl3 = false;
        GContact gContact2 = $this$apply;
        Phone phone = insurer.getPhone();
        if (phone != null) {
            Phone phone2 = phone;
            GContact gContact3 = gContact2;
            boolean bl4 = false;
            boolean bl5 = false;
            Phone it = phone2;
            boolean bl6 = false;
            GPhone gPhone2 = new GPhone(it.getValue());
            gContact2 = gContact3;
            gPhone = gPhone2;
        } else {
            gPhone = new GPhone();
        }
        gContact2.setPhone(gPhone);
        $this$apply.setEmail(conditions.getEmail());
        return gContact;
    }

    private final GContact createContact(Contact contact) {
        GContact gContact = this.createSubject(contact);
        boolean bl = false;
        boolean bl2 = false;
        GContact $this$apply = gContact;
        boolean bl3 = false;
        $this$apply.setAddresses(this.createAddresses(contact));
        $this$apply.setDocuments(this.createPassports(contact));
        return gContact;
    }

    private final GContact createSubject(Subject<?, ?> subject) {
        GContact gContact = new GContact();
        boolean bl = false;
        boolean bl2 = false;
        GContact $this$apply = gContact;
        boolean bl3 = false;
        $this$apply.setPublicId(subject.getId());
        $this$apply.setSubjectNumber(subject.getSubjectNumber());
        $this$apply.setFirstName(subject.getFirstName());
        $this$apply.setLastName(subject.getLastName());
        $this$apply.setMiddleName(subject.getMiddleName());
        Subject.Gender gender = subject.getGender();
        if (gender == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.setGender(gender.toStringEn());
        Date date = subject.getBirthDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.setBirthDate(DateUtils.formatDate(date));
        return gContact;
    }

    private final GContact createDriverContact(Driver driver) {
        GContact gContact = this.createSubject(driver);
        boolean bl = false;
        boolean bl2 = false;
        GContact $this$apply = gContact;
        boolean bl3 = false;
        GVehicleDocument[] gVehicleDocumentArray = new GVehicleDocument[1];
        Object DriverLicenseType = driver.getDriverLicense();
        if (DriverLicenseType == null) {
            Intrinsics.throwNpe();
        }
        String string = ((FullDriverLicense)DriverLicenseType).getSeries();
        Object DriverLicenseType2 = driver.getDriverLicense();
        if (DriverLicenseType2 == null) {
            Intrinsics.throwNpe();
        }
        String string2 = ((FullDriverLicense)DriverLicenseType2).getNumber();
        Object DriverLicenseType3 = driver.getDriverLicense();
        if (DriverLicenseType3 == null) {
            Intrinsics.throwNpe();
        }
        Date date = ((FullDriverLicense)DriverLicenseType3).getIssueDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        gVehicleDocumentArray[0] = new GVehicleDocument("DrivingLicense", string, string2, DateUtils.formatDate(date), false, 16, null);
        $this$apply.setDocuments(gVehicleDocumentArray);
        Object DriverLicenseType4 = driver.getDriverLicense();
        if (DriverLicenseType4 == null) {
            Intrinsics.throwNpe();
        }
        Date date2 = ((FullDriverLicense)DriverLicenseType4).getFirstYearIssueDate();
        if (date2 == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.setDateOfFIDL(DateUtils.formatDate(date2));
        return gContact;
    }

    private final boolean checkSamePerson(GContact contact, Subject<?, ?> subject) {
        String string = contact.getBirthDate();
        Date date = subject.getBirthDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        return Intrinsics.areEqual((Object)string, (Object)DateUtils.formatDate(date)) && Intrinsics.areEqual((Object)contact.getFirstName(), (Object)subject.getFirstName()) && Intrinsics.areEqual((Object)contact.getLastName(), (Object)subject.getLastName()) && Intrinsics.areEqual((Object)contact.getMiddleName(), (Object)subject.getMiddleName());
    }

    private final boolean checkSamePerson(Contact contact, Insurer insurer) {
        Date date = contact.getBirthDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        String string = DateUtils.formatDate(date);
        Date date2 = insurer.getBirthDate();
        if (date2 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)string, (Object)DateUtils.formatDate(date2)) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)contact.getFirstName(), (Object)insurer.getFirstName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)contact.getLastName(), (Object)insurer.getLastName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)contact.getMiddleName(), (Object)insurer.getMiddleName()) ^ true) {
            return false;
        }
        Address address = contact.getHomeAddress();
        if (address == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)address, (Object)insurer.getHomeAddress()) ^ true) {
            return false;
        }
        Address address2 = contact.getRegisteredAddress();
        if (address2 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)address2, (Object)insurer.getRegisteredAddress()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)contact.getPassport(), (Object)insurer.getPassport());
    }

    private final GDriver createDriver(Driver driver) {
        int n = driver.getSubjectNumber();
        Object DriverLicenseType = driver.getDriverLicense();
        if (DriverLicenseType == null) {
            Intrinsics.throwNpe();
        }
        Date date = ((FullDriverLicense)DriverLicenseType).getFirstYearIssueDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        return new GDriver(n, DateUtils.formatDate(date));
    }

    private final GVehicleDocument[] createPassports(Contact contact) {
        GVehicleDocument[] gVehicleDocumentArray = new GVehicleDocument[1];
        Passport passport = contact.getPassport();
        if (passport == null) {
            Intrinsics.throwNpe();
        }
        String string = passport.getSeries();
        String string2 = contact.getPassport().getNumber();
        Date date = contact.getPassport().getDateIssue();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        gVehicleDocumentArray[0] = new GVehicleDocument("Passport", string, string2, DateUtils.formatDate(date), false, 16, null);
        return gVehicleDocumentArray;
    }

    private final GVehicleLegalInfo createLegalInfo() {
        GVehicleLegalInfo gVehicleLegalInfo = new GVehicleLegalInfo();
        boolean bl = false;
        boolean bl2 = false;
        GVehicleLegalInfo $this$apply = gVehicleLegalInfo;
        boolean bl3 = false;
        $this$apply.Vin = this.vehicleDocument.getVin();
        Vehicle vehicle = this.data.getVehicle();
        if (vehicle == null) {
            Intrinsics.throwNpe();
        }
        Year year = vehicle.getProperties().getYear();
        if (year == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.Year = year.getIntValue();
        String string = String.valueOf((Object)this.vehicleDocument.getTypeDocument());
        String string2 = this.vehicleDocument.getSeries();
        String string3 = this.vehicleDocument.getNumber();
        Date date = this.vehicleDocument.getIssueDate();
        if (date == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.Document = new GVehicleDocument(string, string2, string3, DateUtils.formatDate(date), false, 16, null);
        Vehicle vehicle2 = this.data.getVehicle();
        if (vehicle2 == null) {
            Intrinsics.throwNpe();
        }
        VehicleDetails vehicleDetails = vehicle2.getDetails();
        if (vehicleDetails == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.Cost = vehicleDetails.getPrice();
        Address address = this.owner.getHomeAddress();
        if (address == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.UsageRegionCode = address.getRegion();
        Address address2 = this.owner.getHomeAddress();
        if (address2 == null) {
            Intrinsics.throwNpe();
        }
        $this$apply.UseRegion = address2.getRegion();
        $this$apply.RegistrationNumber = this.vehicleDocument.getLicensePlate();
        if (this.conditions.getExpirationDC() != null) {
            String string4 = this.conditions.getNumberDC();
            Date date2 = this.conditions.getExpirationDC();
            if (date2 == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.TechInspectionInfo = new GTechInspectionInfo(string4, DateUtils.formatDate(date2));
        }
        return gVehicleLegalInfo;
    }

    private final GAddress[] createAddresses(Contact contact) {
        GAddress[] gAddressArray = new GAddress[2];
        Address address = contact.getRegisteredAddress();
        if (address == null) {
            Intrinsics.throwNpe();
        }
        gAddressArray[0] = new GAddress("Registration", address);
        Address address2 = contact.getHomeAddress();
        if (address2 == null) {
            Intrinsics.throwNpe();
        }
        gAddressArray[1] = new GAddress("Home", address2);
        return gAddressArray;
    }

    @NotNull
    protected final QuickQuoteData getData() {
        return this.data;
    }

    protected final void setData(@NotNull QuickQuoteData quickQuoteData) {
        Intrinsics.checkParameterIsNotNull((Object)quickQuoteData, (String)"<set-?>");
        this.data = quickQuoteData;
    }

    public PriceParamsBuilder(@NotNull QuickQuoteData data, @NotNull FullQuoteData fullQuoteData, @Nullable String dealId, @Nullable String marketingSource, @Nullable String marketingChannel, @Nullable InsuranceRate insuranceRate) {
        VehicleDocument vehicleDocument;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)fullQuoteData, (String)"fullQuoteData");
        this.data = data;
        this.insuranceRate = insuranceRate;
        Serializable serializable = fullQuoteData.getVehicleDocument();
        PriceParamsBuilder priceParamsBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (serializable == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        priceParamsBuilder.vehicleDocument = vehicleDocument = serializable;
        serializable = fullQuoteData.getInsurer();
        priceParamsBuilder = this;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (serializable == null) {
            boolean bl5 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        vehicleDocument = serializable;
        priceParamsBuilder.insurer = vehicleDocument;
        serializable = fullQuoteData.getOwner();
        priceParamsBuilder = this;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (serializable == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        vehicleDocument = serializable;
        priceParamsBuilder.owner = vehicleDocument;
        serializable = fullQuoteData.getDrivers();
        priceParamsBuilder = this;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (serializable == null) {
            boolean bl7 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        vehicleDocument = serializable;
        priceParamsBuilder.drivers = vehicleDocument;
        serializable = fullQuoteData.getConditions();
        priceParamsBuilder = this;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (serializable == null) {
            boolean bl8 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        vehicleDocument = serializable;
        priceParamsBuilder.conditions = vehicleDocument;
        this.dealId = dealId;
        this.marketingSource = marketingSource;
        this.marketingChannel = marketingChannel;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/tinkoff/tisdk/gateway/converter/builders/PriceParamsBuilder$Companion;", "", "()V", "KEY_RATE_ONLY", "", "tisdk-domain"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

